/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.conditions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.nmoncho.shaded.com.google.common.collect.Iterators;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class ColumnCondition {
    public final ColumnMetadata column;
    public final Operator operator;
    private final Terms terms;

    private ColumnCondition(ColumnMetadata column, Operator op, Terms terms) {
        this.column = column;
        this.operator = op;
        this.terms = terms;
    }

    public void addFunctionsTo(List<Function> functions) {
        this.terms.addFunctionsTo(functions);
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        this.terms.collectMarkerSpecification(boundNames);
    }

    public abstract Bound bind(QueryOptions var1);

    protected final List<ByteBuffer> bindAndGetTerms(QueryOptions options) {
        return this.filterUnsetValuesIfNeeded(this.checkValues(this.terms.bindAndGet(options)));
    }

    protected final List<Term.Terminal> bindTerms(QueryOptions options) {
        return this.filterUnsetValuesIfNeeded(this.checkValues(this.terms.bind(options)));
    }

    private <T> List<T> checkValues(List<T> values) {
        RequestValidations.checkFalse(values == null && this.operator.isIN(), "Invalid null list in IN condition");
        RequestValidations.checkFalse(values == Terms.UNSET_LIST, "Invalid 'unset' value in condition");
        return values;
    }

    private <T> List<T> filterUnsetValuesIfNeeded(List<T> values) {
        if (!this.operator.isIN()) {
            return values;
        }
        ArrayList<T> filtered = new ArrayList<T>(values.size());
        int m = values.size();
        for (int i = 0; i < m; ++i) {
            T value = values.get(i);
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER || value == Constants.UNSET_VALUE) continue;
            filtered.add(value);
        }
        return filtered;
    }

    public static ColumnCondition condition(ColumnMetadata column, Operator op, Terms terms) {
        return new SimpleColumnCondition(column, op, terms);
    }

    public static ColumnCondition condition(ColumnMetadata column, Term collectionElement, Operator op, Terms terms) {
        return new CollectionElementCondition(column, collectionElement, op, terms);
    }

    public static ColumnCondition condition(ColumnMetadata column, FieldIdentifier udtField, Operator op, Terms terms) {
        return new UDTFieldCondition(column, udtField, op, terms);
    }

    protected static final Cell<?> getCell(Row row, ColumnMetadata column) {
        return row == null ? null : row.getCell(column);
    }

    protected static final Cell<?> getCell(Row row, ColumnMetadata column, CellPath path) {
        return row == null ? null : row.getCell(column, path);
    }

    protected static final Iterator<Cell<?>> getCells(Row row, ColumnMetadata column) {
        if (row == null) {
            return Collections.emptyIterator();
        }
        ComplexColumnData complexData = row.getComplexColumnData(column);
        return complexData == null ? Collections.emptyIterator() : complexData.iterator();
    }

    protected static final boolean evaluateComparisonWithOperator(int comparison, Operator operator) {
        switch (operator) {
            case EQ: {
                return false;
            }
            case LT: 
            case LTE: {
                return comparison < 0;
            }
            case GT: 
            case GTE: {
                return comparison > 0;
            }
            case NEQ: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private static boolean containsAppliesTo(CollectionType<?> type, Iterator<Cell<?>> iter, ByteBuffer value, Operator operator) {
        AbstractType<Object> compareType;
        switch (type.kind) {
            case LIST: {
                compareType = ((ListType)type).getElementsType();
                break;
            }
            case SET: {
                compareType = ((SetType)type).getElementsType();
                break;
            }
            case MAP: {
                compareType = operator.isContainsKey() ? ((MapType)type).getKeysType() : ((MapType)type).getValuesType();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        boolean appliesToSetOrMapKeys = type.kind == CollectionType.Kind.SET || type.kind == CollectionType.Kind.MAP && operator.isContainsKey();
        return ColumnCondition.containsAppliesTo(compareType, iter, value, appliesToSetOrMapKeys);
    }

    private static boolean containsAppliesTo(AbstractType<?> type, Iterator<Cell<?>> iter, ByteBuffer value, Boolean appliesToSetOrMapKeys) {
        while (iter.hasNext()) {
            ByteBuffer cellValue = appliesToSetOrMapKeys != false ? iter.next().path().get(0) : iter.next().buffer();
            if (type.compare(cellValue, value) != 0) continue;
            return true;
        }
        return false;
    }

    public static class Raw {
        private final Term.Raw value;
        private final List<Term.Raw> inValues;
        private final AbstractMarker.INRaw inMarker;
        private final Term.Raw collectionElement;
        private final FieldIdentifier udtField;
        private final Operator operator;

        private Raw(Term.Raw value, List<Term.Raw> inValues, AbstractMarker.INRaw inMarker, Term.Raw collectionElement, FieldIdentifier udtField, Operator op) {
            this.value = value;
            this.inValues = inValues;
            this.inMarker = inMarker;
            this.collectionElement = collectionElement;
            this.udtField = udtField;
            this.operator = op;
        }

        public static Raw simpleCondition(Term.Raw value, Operator op) {
            return new Raw(value, null, null, null, null, op);
        }

        public static Raw simpleInCondition(List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, null, null, Operator.IN);
        }

        public static Raw simpleInCondition(AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, null, null, Operator.IN);
        }

        public static Raw collectionCondition(Term.Raw value, Term.Raw collectionElement, Operator op) {
            return new Raw(value, null, null, collectionElement, null, op);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, collectionElement, null, Operator.IN);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, collectionElement, null, Operator.IN);
        }

        public static Raw udtFieldCondition(Term.Raw value, FieldIdentifier udtField, Operator op) {
            return new Raw(value, null, null, null, udtField, op);
        }

        public static Raw udtFieldInCondition(FieldIdentifier udtField, List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, null, udtField, Operator.IN);
        }

        public static Raw udtFieldInCondition(FieldIdentifier udtField, AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, null, udtField, Operator.IN);
        }

        public ColumnCondition prepare(String keyspace, ColumnMetadata receiver, TableMetadata cfm) {
            if (receiver.type instanceof CounterColumnType) {
                throw RequestValidations.invalidRequest("Conditions on counters are not supported");
            }
            if (this.collectionElement != null) {
                ColumnSpecification valueSpec;
                ColumnSpecification elementSpec;
                if (!receiver.type.isCollection()) {
                    throw RequestValidations.invalidRequest("Invalid element access syntax for non-collection column %s", receiver.name);
                }
                switch (((CollectionType)receiver.type).kind) {
                    case LIST: {
                        elementSpec = Lists.indexSpecOf(receiver);
                        valueSpec = Lists.valueSpecOf(receiver);
                        break;
                    }
                    case MAP: {
                        elementSpec = Maps.keySpecOf(receiver);
                        valueSpec = Maps.valueSpecOf(receiver);
                        break;
                    }
                    case SET: {
                        throw RequestValidations.invalidRequest("Invalid element access syntax for set column %s", receiver.name);
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.validateOperationOnDurations(valueSpec.type);
                return ColumnCondition.condition(receiver, this.collectionElement.prepare(keyspace, elementSpec), this.operator, this.prepareTerms(keyspace, valueSpec));
            }
            if (this.udtField != null) {
                UserType userType = (UserType)receiver.type;
                int fieldPosition = userType.fieldPosition(this.udtField);
                if (fieldPosition == -1) {
                    throw RequestValidations.invalidRequest("Unknown field %s for column %s", this.udtField, receiver.name);
                }
                ColumnSpecification fieldReceiver = UserTypes.fieldSpecOf(receiver, fieldPosition);
                this.validateOperationOnDurations(fieldReceiver.type);
                return ColumnCondition.condition(receiver, this.udtField, this.operator, this.prepareTerms(keyspace, fieldReceiver));
            }
            this.validateOperationOnDurations(receiver.type);
            return ColumnCondition.condition(receiver, this.operator, this.prepareTerms(keyspace, receiver));
        }

        private Terms prepareTerms(String keyspace, ColumnSpecification receiver) {
            RequestValidations.checkFalse(this.operator.isContainsKey() && !(receiver.type instanceof MapType), "Cannot use CONTAINS KEY on non-map column %s", receiver.name);
            RequestValidations.checkFalse(this.operator.isContains() && !receiver.type.isCollection(), "Cannot use CONTAINS on non-collection column %s", receiver.name);
            if (this.operator.isIN()) {
                return this.inValues == null ? Terms.ofListMarker(this.inMarker.prepare(keyspace, receiver), receiver.type) : Terms.of(Raw.prepareTerms(keyspace, receiver, this.inValues));
            }
            if (this.operator.isContains() || this.operator.isContainsKey()) {
                receiver = ((CollectionType)receiver.type).makeCollectionReceiver(receiver, this.operator.isContainsKey());
            }
            return Terms.of(this.value.prepare(keyspace, receiver));
        }

        private static List<Term> prepareTerms(String keyspace, ColumnSpecification receiver, List<Term.Raw> raws) {
            ArrayList<Term> terms = new ArrayList<Term>(raws.size());
            int m = raws.size();
            for (int i = 0; i < m; ++i) {
                Term.Raw raw = raws.get(i);
                terms.add(raw.prepare(keyspace, receiver));
            }
            return terms;
        }

        private void validateOperationOnDurations(AbstractType<?> type) {
            if (type.referencesDuration() && this.operator.isSlice()) {
                RequestValidations.checkFalse(type.isCollection(), "Slice conditions are not supported on collections containing durations");
                RequestValidations.checkFalse(type.isTuple(), "Slice conditions are not supported on tuples containing durations");
                RequestValidations.checkFalse(type.isUDT(), "Slice conditions are not supported on UDTs containing durations");
                throw RequestValidations.invalidRequest("Slice conditions ( %s ) are not supported on durations", new Object[]{this.operator});
            }
        }

        public Term.Raw getValue() {
            return this.value;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static final class MultiCellUdtBound
    extends Bound {
        private final List<ByteBuffer> values;
        private final ProtocolVersion protocolVersion;

        private MultiCellUdtBound(ColumnMetadata column, Operator op, List<ByteBuffer> values, ProtocolVersion protocolVersion) {
            super(column, op);
            assert (column.type.isMultiCell());
            this.values = values;
            this.protocolVersion = protocolVersion;
        }

        @Override
        public boolean appliesTo(Row row) {
            return this.isSatisfiedBy(this.rowValue(row));
        }

        private final ByteBuffer rowValue(Row row) {
            UserType userType = (UserType)this.column.type;
            Iterator<Cell<?>> iter = ColumnCondition.getCells(row, this.column);
            return iter.hasNext() ? userType.serializeForNativeProtocol(iter, this.protocolVersion) : null;
        }

        private boolean isSatisfiedBy(ByteBuffer rowValue) {
            for (ByteBuffer value : this.values) {
                if (!MultiCellUdtBound.compareWithOperator(this.comparisonOperator, this.column.type, value, rowValue)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static final class UDTFieldAccessBound
    extends Bound {
        private final FieldIdentifier field;
        private final List<ByteBuffer> values;

        private UDTFieldAccessBound(ColumnMetadata column, FieldIdentifier field, Operator operator, List<ByteBuffer> values) {
            super(column, operator);
            assert (column.type.isUDT() && field != null);
            this.field = field;
            this.values = values;
        }

        @Override
        public boolean appliesTo(Row row) {
            return this.isSatisfiedBy(this.rowValue(row));
        }

        private ByteBuffer rowValue(Row row) {
            UserType userType = (UserType)this.column.type;
            if (this.column.type.isMultiCell()) {
                Cell<?> cell = ColumnCondition.getCell(row, this.column, userType.cellPathForField(this.field));
                return cell == null ? null : cell.buffer();
            }
            Cell<?> cell = ColumnCondition.getCell(row, this.column);
            return cell == null ? null : userType.split(cell.buffer())[userType.fieldPosition(this.field)];
        }

        private boolean isSatisfiedBy(ByteBuffer rowValue) {
            UserType userType = (UserType)this.column.type;
            int fieldPosition = userType.fieldPosition(this.field);
            AbstractType<?> valueType = userType.fieldType(fieldPosition);
            for (ByteBuffer value : this.values) {
                if (!UDTFieldAccessBound.compareWithOperator(this.comparisonOperator, valueType, value, rowValue)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static final class MultiCellCollectionBound
    extends Bound {
        private final List<Term.Terminal> values;

        public MultiCellCollectionBound(ColumnMetadata column, Operator operator, List<Term.Terminal> values) {
            super(column, operator);
            assert (column.type.isMultiCell());
            this.values = values;
        }

        @Override
        public boolean appliesTo(Row row) {
            CollectionType type = (CollectionType)this.column.type;
            for (Term.Terminal value : this.values) {
                Iterator<Cell<?>> iter = ColumnCondition.getCells(row, this.column);
                if (value == null || !this.comparisonOperator.isContains() && !this.comparisonOperator.isContainsKey() && this.isEmpty(type, value)) {
                    if (this.comparisonOperator == Operator.EQ) {
                        if (iter.hasNext()) continue;
                        return true;
                    }
                    if (this.comparisonOperator == Operator.NEQ) {
                        return iter.hasNext();
                    }
                    if (value == null) {
                        throw RequestValidations.invalidRequest("Invalid comparison with null for operator \"%s\"", new Object[]{this.comparisonOperator});
                    }
                    throw RequestValidations.invalidRequest("Invalid comparison with an empty %s for operator \"%s\"", new Object[]{type.kind, this.comparisonOperator});
                }
                if (!MultiCellCollectionBound.valueAppliesTo(type, iter, value, this.comparisonOperator)) continue;
                return true;
            }
            return false;
        }

        private boolean isEmpty(CollectionType<?> type, Term.Terminal value) {
            switch (type.kind) {
                case LIST: {
                    return ((Lists.Value)value).elements.isEmpty();
                }
                case SET: {
                    return ((Sets.Value)value).elements.isEmpty();
                }
                case MAP: {
                    return ((Maps.Value)value).map.isEmpty();
                }
            }
            throw new AssertionError();
        }

        private static boolean valueAppliesTo(CollectionType<?> type, Iterator<Cell<?>> iter, Term.Terminal value, Operator operator) {
            if (!iter.hasNext() && operator != Operator.NEQ) {
                return false;
            }
            if (operator.isContains() || operator.isContainsKey()) {
                return ColumnCondition.containsAppliesTo(type, iter, value.get(ProtocolVersion.CURRENT), operator);
            }
            switch (type.kind) {
                case LIST: {
                    List<ByteBuffer> valueList = ((Lists.Value)value).elements;
                    return MultiCellCollectionBound.listAppliesTo((ListType)type, iter, valueList, operator);
                }
                case SET: {
                    SortedSet<ByteBuffer> valueSet = ((Sets.Value)value).elements;
                    return MultiCellCollectionBound.setAppliesTo((SetType)type, iter, valueSet, operator);
                }
                case MAP: {
                    SortedMap<ByteBuffer, ByteBuffer> valueMap = ((Maps.Value)value).map;
                    return MultiCellCollectionBound.mapAppliesTo((MapType)type, iter, valueMap, operator);
                }
            }
            throw new AssertionError();
        }

        private static boolean setOrListAppliesTo(AbstractType<?> type, Iterator<Cell<?>> iter, Iterator<ByteBuffer> conditionIter, Operator operator, boolean isSet) {
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator == Operator.GT || operator == Operator.GTE || operator == Operator.NEQ;
                }
                ByteBuffer cellValue = isSet ? iter.next().path().get(0) : iter.next().buffer();
                int comparison = type.compare(cellValue, conditionIter.next());
                if (comparison == 0) continue;
                return ColumnCondition.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator == Operator.LT || operator == Operator.LTE || operator == Operator.NEQ;
            }
            return operator == Operator.EQ || operator == Operator.LTE || operator == Operator.GTE;
        }

        private static boolean listAppliesTo(ListType<?> type, Iterator<Cell<?>> iter, List<ByteBuffer> elements, Operator operator) {
            return MultiCellCollectionBound.setOrListAppliesTo(type.getElementsType(), iter, elements.iterator(), operator, false);
        }

        private static boolean setAppliesTo(SetType<?> type, Iterator<Cell<?>> iter, Set<ByteBuffer> elements, Operator operator) {
            ArrayList<ByteBuffer> sortedElements = new ArrayList<ByteBuffer>(elements);
            Collections.sort(sortedElements, type.getElementsType());
            return MultiCellCollectionBound.setOrListAppliesTo(type.getElementsType(), iter, sortedElements.iterator(), operator, true);
        }

        private static boolean mapAppliesTo(MapType<?, ?> type, Iterator<Cell<?>> iter, Map<ByteBuffer, ByteBuffer> elements, Operator operator) {
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> conditionIter = elements.entrySet().iterator();
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator == Operator.GT || operator == Operator.GTE || operator == Operator.NEQ;
                }
                Map.Entry<ByteBuffer, ByteBuffer> conditionEntry = conditionIter.next();
                Cell<?> c = iter.next();
                int comparison = type.getKeysType().compare(c.path().get(0), conditionEntry.getKey());
                if (comparison != 0) {
                    return ColumnCondition.evaluateComparisonWithOperator(comparison, operator);
                }
                comparison = type.getValuesType().compare(c.buffer(), conditionEntry.getValue());
                if (comparison == 0) continue;
                return ColumnCondition.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator == Operator.LT || operator == Operator.LTE || operator == Operator.NEQ;
            }
            return operator == Operator.EQ || operator == Operator.LTE || operator == Operator.GTE;
        }
    }

    private static final class ElementAccessBound
    extends Bound {
        private final ByteBuffer collectionElement;
        private final List<ByteBuffer> values;

        private ElementAccessBound(ColumnMetadata column, ByteBuffer collectionElement, Operator operator, List<ByteBuffer> values) {
            super(column, operator);
            this.collectionElement = collectionElement;
            this.values = values;
        }

        @Override
        public boolean appliesTo(Row row) {
            boolean isMap = this.column.type instanceof MapType;
            if (this.collectionElement == null) {
                throw RequestValidations.invalidRequest("Invalid null value for %s element access", isMap ? "map" : "list");
            }
            if (isMap) {
                MapType mapType = (MapType)this.column.type;
                ByteBuffer rowValue = this.rowMapValue(mapType, row);
                return this.isSatisfiedBy(mapType.getKeysType(), rowValue);
            }
            ListType listType = (ListType)this.column.type;
            ByteBuffer rowValue = this.rowListValue(listType, row);
            return this.isSatisfiedBy(listType.getElementsType(), rowValue);
        }

        private ByteBuffer rowMapValue(MapType<?, ?> type, Row row) {
            if (this.column.type.isMultiCell()) {
                Cell<?> cell = ColumnCondition.getCell(row, this.column, CellPath.create(this.collectionElement));
                return cell == null ? null : cell.buffer();
            }
            Cell<?> cell = ColumnCondition.getCell(row, this.column);
            return cell == null ? null : ((MapSerializer)type.getSerializer()).getSerializedValue(cell.buffer(), this.collectionElement, type.getKeysType());
        }

        private ByteBuffer rowListValue(ListType<?> type, Row row) {
            if (this.column.type.isMultiCell()) {
                return ElementAccessBound.cellValueAtIndex(ColumnCondition.getCells(row, this.column), ElementAccessBound.getListIndex(this.collectionElement));
            }
            Cell<?> cell = ColumnCondition.getCell(row, this.column);
            return cell == null ? null : ((ListSerializer)type.getSerializer()).getElement(cell.buffer(), ElementAccessBound.getListIndex(this.collectionElement));
        }

        private static ByteBuffer cellValueAtIndex(Iterator<Cell<?>> iter, int index) {
            int adv = Iterators.advance(iter, index);
            if (adv == index && iter.hasNext()) {
                return iter.next().buffer();
            }
            return null;
        }

        private boolean isSatisfiedBy(AbstractType<?> valueType, ByteBuffer rowValue) {
            for (ByteBuffer value : this.values) {
                if (!ElementAccessBound.compareWithOperator(this.comparisonOperator, valueType, value, rowValue)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ByteBuffer getCollectionElementValue() {
            return this.collectionElement;
        }

        private static int getListIndex(ByteBuffer collectionElement) {
            int idx = ByteBufferUtil.toInt(collectionElement);
            RequestValidations.checkFalse(idx < 0, "Invalid negative list index %d", idx);
            return idx;
        }
    }

    private static final class SimpleBound
    extends Bound {
        private final List<ByteBuffer> values;

        private SimpleBound(ColumnMetadata column, Operator operator, List<ByteBuffer> values) {
            super(column, operator);
            this.values = values;
        }

        @Override
        public boolean appliesTo(Row row) {
            return this.isSatisfiedBy(this.rowValue(row));
        }

        private ByteBuffer rowValue(Row row) {
            Cell<?> c = ColumnCondition.getCell(row, this.column);
            return c == null ? null : c.buffer();
        }

        private boolean isSatisfiedBy(ByteBuffer rowValue) {
            for (ByteBuffer value : this.values) {
                if (!SimpleBound.compareWithOperator(this.comparisonOperator, this.column.type, value, rowValue)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class Bound {
        public final ColumnMetadata column;
        public final Operator comparisonOperator;

        protected Bound(ColumnMetadata column, Operator operator) {
            this.column = column;
            this.comparisonOperator = operator.isIN() ? Operator.EQ : operator;
        }

        public abstract boolean appliesTo(Row var1);

        public ByteBuffer getCollectionElementValue() {
            return null;
        }

        protected static boolean compareWithOperator(Operator operator, AbstractType<?> type, ByteBuffer value, ByteBuffer otherValue) {
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw RequestValidations.invalidRequest("Invalid 'unset' value in condition");
            }
            if (value == null) {
                switch (operator) {
                    case EQ: {
                        return otherValue == null;
                    }
                    case NEQ: {
                        return otherValue != null;
                    }
                }
                throw RequestValidations.invalidRequest("Invalid comparison with null for operator \"%s\"", new Object[]{operator});
            }
            if (otherValue == null) {
                return operator == Operator.NEQ;
            }
            return operator.isSatisfiedBy(type, otherValue, value);
        }
    }

    private static final class UDTFieldCondition
    extends ColumnCondition {
        private final FieldIdentifier udtField;

        public UDTFieldCondition(ColumnMetadata column, FieldIdentifier udtField, Operator op, Terms values) {
            super(column, op, values);
            assert (udtField != null);
            this.udtField = udtField;
        }

        @Override
        public Bound bind(QueryOptions options) {
            return new UDTFieldAccessBound(this.column, this.udtField, this.operator, this.bindAndGetTerms(options));
        }
    }

    private static class CollectionElementCondition
    extends ColumnCondition {
        private final Term collectionElement;

        public CollectionElementCondition(ColumnMetadata column, Term collectionElement, Operator op, Terms values) {
            super(column, op, values);
            this.collectionElement = collectionElement;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.collectionElement.addFunctionsTo(functions);
            super.addFunctionsTo(functions);
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            this.collectionElement.collectMarkerSpecification(boundNames);
            super.collectMarkerSpecification(boundNames);
        }

        @Override
        public Bound bind(QueryOptions options) {
            return new ElementAccessBound(this.column, this.collectionElement.bindAndGet(options), this.operator, this.bindAndGetTerms(options));
        }
    }

    private static final class SimpleColumnCondition
    extends ColumnCondition {
        public SimpleColumnCondition(ColumnMetadata column, Operator op, Terms values) {
            super(column, op, values);
        }

        @Override
        public Bound bind(QueryOptions options) {
            if (this.column.type.isCollection() && this.column.type.isMultiCell()) {
                return new MultiCellCollectionBound(this.column, this.operator, this.bindTerms(options));
            }
            if (this.column.type.isUDT() && this.column.type.isMultiCell()) {
                return new MultiCellUdtBound(this.column, this.operator, this.bindAndGetTerms(options), options.getProtocolVersion());
            }
            return new SimpleBound(this.column, this.operator, this.bindAndGetTerms(options));
        }
    }
}

