/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import org.apache.cassandra.exceptions.ConfigurationException;

public final class ReservedKeywords {
    private static final String FILE_NAME = "reserved_keywords.txt";
    @VisibleForTesting
    static final Set<String> reservedKeywords = ReservedKeywords.getFromResource();

    private static Set<String> getFromResource() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        try (InputStream is = ReservedKeywords.class.getResource(FILE_NAME).openConnection().getInputStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                builder.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(String.format("Unable to read reserved keywords file '%s'", FILE_NAME), e);
        }
        return builder.build();
    }

    public static boolean isReserved(String text) {
        return reservedKeywords.contains(text.toUpperCase());
    }
}

