/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.nmoncho.shaded.com.google.common.collect.Maps;
import org.apache.cassandra.config.DefaultLoader;
import org.apache.cassandra.config.ForwardingProperty;
import org.apache.cassandra.config.Loader;
import org.yaml.snakeyaml.introspector.Property;

public final class Properties {
    public static final String DELIMITER = ".";

    private Properties() {
    }

    public static Property andThen(Property root, Property leaf, String delimiter) {
        return new AndThen(root, leaf, delimiter);
    }

    public static Property andThen(Property root, Property leaf) {
        return Properties.andThen(root, leaf, DELIMITER);
    }

    public static Map<String, Property> flatten(Loader loader, Map<String, Property> input) {
        return Properties.flatten(loader, input, DELIMITER);
    }

    public static Map<String, Property> flatten(Loader loader, Map<String, Property> input, String delimiter) {
        ArrayDeque<Property> queue = new ArrayDeque<Property>(input.values());
        HashMap<String, Property> output = Maps.newHashMapWithExpectedSize(input.size());
        while (!queue.isEmpty()) {
            Map children;
            Property prop = (Property)queue.poll();
            Map<Object, Object> map = children = Properties.isPrimitive(prop) || Properties.isCollection(prop) ? Collections.emptyMap() : loader.getProperties(prop.getType());
            if (children.isEmpty()) {
                output.put(prop.getName(), prop);
                continue;
            }
            children.values().stream().map(p -> Properties.andThen(prop, p, delimiter)).forEach(queue::add);
        }
        return output;
    }

    public static boolean isCollection(Property prop) {
        return Collection.class.isAssignableFrom(prop.getType()) || Map.class.isAssignableFrom(prop.getType());
    }

    public static boolean isPrimitive(Property prop) {
        Class type = prop.getType();
        return type.isPrimitive() || type.isEnum() || type.equals(String.class) || Number.class.isAssignableFrom(type) || Boolean.class.equals((Object)type);
    }

    public static Loader defaultLoader() {
        return new DefaultLoader();
    }

    public static Property rename(String newName, Property prop) {
        return new ForwardingProperty(newName, prop);
    }

    private static final class AndThen
    extends ForwardingProperty {
        private final Property root;
        private final Property leaf;

        AndThen(Property root, Property leaf, String delimiter) {
            super(root.getName() + delimiter + leaf.getName(), leaf);
            this.root = root;
            this.leaf = leaf;
        }

        @Override
        public void set(Object object, Object value) throws Exception {
            Object parent = this.root.get(object);
            if (parent == null) {
                Constructor c = this.root.getType().getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                parent = c.newInstance(new Object[0]);
                this.root.set(object, parent);
            }
            this.leaf.set(parent, value);
        }

        @Override
        public Object get(Object object) {
            try {
                Object parent = this.root.get(object);
                if (parent == null) {
                    return null;
                }
                return this.leaf.get(parent);
            }
            catch (Exception e) {
                if (!(this.root instanceof AndThen)) {
                    e.addSuppressed(new RuntimeException("Error calling get() on " + (Object)((Object)this)));
                }
                throw e;
            }
        }
    }
}

