/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.math.DoubleMath;
import net.nmoncho.shaded.com.google.common.primitives.Ints;

public abstract class DataRateSpec {
    private static final Pattern UNITS_PATTERN = Pattern.compile("^(\\d+)(MiB/s|KiB/s|B/s)$");
    private final long quantity;
    private final DataRateUnit unit;

    private DataRateSpec(String value) {
        Matcher matcher = UNITS_PATTERN.matcher(value);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid data rate: " + value + " Accepted units: MiB/s, KiB/s, B/s where case matters and only non-negative values are valid");
        }
        this.quantity = Long.parseLong(matcher.group(1));
        this.unit = DataRateUnit.fromSymbol(matcher.group(2));
    }

    private DataRateSpec(String value, DataRateUnit minUnit, long max) {
        this(value);
        DataRateSpec.validateQuantity(value, this.quantity(), this.unit(), minUnit, max);
    }

    private DataRateSpec(long quantity, DataRateUnit unit, DataRateUnit minUnit, long max) {
        this.quantity = quantity;
        this.unit = unit;
        DataRateSpec.validateQuantity(quantity, unit, minUnit, max);
    }

    private static void validateQuantity(String value, double quantity, DataRateUnit unit, DataRateUnit minUnit, long max) {
        if (minUnit.convert(quantity, unit) >= (double)max) {
            throw new IllegalArgumentException("Invalid data rate: " + value + ". It shouldn't be more than " + (max - 1L) + " in " + minUnit.name().toLowerCase());
        }
    }

    private static void validateQuantity(double quantity, DataRateUnit unit, DataRateUnit minUnit, long max) {
        if (quantity < 0.0) {
            throw new IllegalArgumentException("Invalid data rate: value must be non-negative");
        }
        if (minUnit.convert(quantity, unit) >= (double)max) {
            throw new IllegalArgumentException(String.format("Invalid data rate: %s %s. It shouldn't be more than %d in %s", quantity, unit.name().toLowerCase(), max - 1L, minUnit.name().toLowerCase()));
        }
    }

    public DataRateUnit unit() {
        return this.unit;
    }

    private double quantity() {
        return this.quantity;
    }

    public double toBytesPerSecond() {
        return this.unit.toBytesPerSecond(this.quantity);
    }

    public int toBytesPerSecondAsInt() {
        return Ints.saturatedCast(Math.round(this.toBytesPerSecond()));
    }

    public double toKibibytesPerSecond() {
        return this.unit.toKibibytesPerSecond(this.quantity);
    }

    public int toKibibytesPerSecondAsInt() {
        return Ints.saturatedCast(Math.round(this.toKibibytesPerSecond()));
    }

    public double toMebibytesPerSecond() {
        return this.unit.toMebibytesPerSecond(this.quantity);
    }

    public int toMebibytesPerSecondAsInt() {
        return Ints.saturatedCast(Math.round(this.toMebibytesPerSecond()));
    }

    public double toMegabitsPerSecond() {
        return this.unit.toMegabitsPerSecond(this.quantity);
    }

    public int toMegabitsPerSecondAsInt() {
        return Ints.saturatedCast(Math.round(this.toMegabitsPerSecond()));
    }

    public int hashCode() {
        return Objects.hash(this.unit.toKibibytesPerSecond(this.quantity));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRateSpec)) {
            return false;
        }
        DataRateSpec other = (DataRateSpec)obj;
        if (this.unit == other.unit) {
            return this.quantity == other.quantity;
        }
        return this.unit.convert(other.quantity, other.unit) == (double)this.quantity && other.unit.convert(this.quantity, this.unit) == (double)other.quantity;
    }

    public String toString() {
        return (DoubleMath.isMathematicalInteger(this.quantity) ? this.quantity : this.quantity) + this.unit.symbol;
    }

    public static class DataRateUnit
    extends Enum<DataRateUnit> {
        public static final /* enum */ DataRateUnit BYTES_PER_SECOND = new DataRateUnit("B/s"){

            @Override
            public double toBytesPerSecond(double d) {
                return d;
            }

            @Override
            public double toKibibytesPerSecond(double d) {
                return d / 1024.0;
            }

            @Override
            public double toMebibytesPerSecond(double d) {
                return d / 1048576.0;
            }

            @Override
            public double toMegabitsPerSecond(double d) {
                return d / 125000.0;
            }

            @Override
            public double convert(double source, DataRateUnit sourceUnit) {
                return sourceUnit.toBytesPerSecond(source);
            }
        };
        public static final /* enum */ DataRateUnit KIBIBYTES_PER_SECOND = new DataRateUnit("KiB/s"){

            @Override
            public double toBytesPerSecond(double d) {
                return 2.x(d, 1024.0, 9.007199254740992E15);
            }

            @Override
            public double toKibibytesPerSecond(double d) {
                return d;
            }

            @Override
            public double toMebibytesPerSecond(double d) {
                return d / 1024.0;
            }

            @Override
            public double toMegabitsPerSecond(double d) {
                return d / 122.0;
            }

            @Override
            public double convert(double source, DataRateUnit sourceUnit) {
                return sourceUnit.toKibibytesPerSecond(source);
            }
        };
        public static final /* enum */ DataRateUnit MEBIBYTES_PER_SECOND = new DataRateUnit("MiB/s"){

            @Override
            public double toBytesPerSecond(double d) {
                return 3.x(d, 1048576.0, 8.796093022208E12);
            }

            @Override
            public double toKibibytesPerSecond(double d) {
                return 3.x(d, 1024.0, 9.007199254740992E15);
            }

            @Override
            public double toMebibytesPerSecond(double d) {
                return d;
            }

            @Override
            public double toMegabitsPerSecond(double d) {
                if (d > 1.099511627776E18) {
                    return 9.223372036854776E18;
                }
                return d * 8.388608;
            }

            @Override
            public double convert(double source, DataRateUnit sourceUnit) {
                return sourceUnit.toMebibytesPerSecond(source);
            }
        };
        static final double MAX = 9.223372036854776E18;
        static final double MEGABITS_PER_MEBIBYTE = 8.388608;
        private final String symbol;
        private static final /* synthetic */ DataRateUnit[] $VALUES;

        public static DataRateUnit[] values() {
            return (DataRateUnit[])$VALUES.clone();
        }

        public static DataRateUnit valueOf(String name) {
            return Enum.valueOf(DataRateUnit.class, name);
        }

        static double x(double d, double m, double over) {
            assert (over > 0.0 && over < 9.223372036854776E18 && over == 9.223372036854776E18 / m);
            if (d > over) {
                return 9.223372036854776E18;
            }
            return d * m;
        }

        public static DataRateUnit fromSymbol(String symbol) {
            for (DataRateUnit value : DataRateUnit.values()) {
                if (!value.symbol.equalsIgnoreCase(symbol)) continue;
                return value;
            }
            throw new IllegalArgumentException(String.format("Unsupported data rate unit: %s. Supported units are: %s", symbol, Arrays.stream(DataRateUnit.values()).map(u -> u.symbol).collect(Collectors.joining(", "))));
        }

        private DataRateUnit(String symbol) {
            this.symbol = symbol;
        }

        public double toBytesPerSecond(double d) {
            throw new AbstractMethodError();
        }

        public double toKibibytesPerSecond(double d) {
            throw new AbstractMethodError();
        }

        public double toMebibytesPerSecond(double d) {
            throw new AbstractMethodError();
        }

        public double toMegabitsPerSecond(double d) {
            throw new AbstractMethodError();
        }

        public double convert(double source, DataRateUnit sourceUnit) {
            throw new AbstractMethodError();
        }

        static {
            $VALUES = new DataRateUnit[]{BYTES_PER_SECOND, KIBIBYTES_PER_SECOND, MEBIBYTES_PER_SECOND};
        }
    }

    public static final class LongBytesPerSecondBound
    extends DataRateSpec {
        public LongBytesPerSecondBound(String value) {
            super(value, DataRateUnit.BYTES_PER_SECOND, Long.MAX_VALUE);
        }

        public LongBytesPerSecondBound(long quantity, DataRateUnit unit) {
            super(quantity, unit, DataRateUnit.BYTES_PER_SECOND, Long.MAX_VALUE);
        }

        public LongBytesPerSecondBound(long bytesPerSecond) {
            this(bytesPerSecond, DataRateUnit.BYTES_PER_SECOND);
        }

        @Deprecated
        public static LongBytesPerSecondBound megabitsPerSecondInBytesPerSecond(long megabitsPerSecond) {
            long BYTES_PER_MEGABIT = 125000L;
            long bytesPerSecond = megabitsPerSecond * 125000L;
            if (megabitsPerSecond >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Invalid data rate: " + megabitsPerSecond + " megabits per second; stream_throughput_outbound and inter_dc_stream_throughput_outbound should be between 0 and " + 0x7FFFFFFE + " in megabits per second");
            }
            return new LongBytesPerSecondBound(bytesPerSecond, DataRateUnit.BYTES_PER_SECOND);
        }
    }
}

