/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.concurrent.ExecutorBuilder;
import org.apache.cassandra.concurrent.ResizableThreadPoolMXBean;
import org.apache.cassandra.concurrent.ThreadPoolExecutorBase;
import org.apache.cassandra.metrics.ThreadPoolMetrics;
import org.apache.cassandra.utils.MBeanWrapper;

@VisibleForTesting
public class ThreadPoolExecutorJMXAdapter
implements Runnable,
ResizableThreadPoolMXBean {
    final String mbeanName;
    final ThreadPoolExecutorBase executor;
    final ThreadPoolMetrics metrics;
    boolean released;

    public static void register(String jmxPath, ThreadPoolExecutorBase executor) {
        new ThreadPoolExecutorJMXAdapter(jmxPath, executor);
    }

    private ThreadPoolExecutorJMXAdapter(String jmxPath, ThreadPoolExecutorBase executor) {
        this.executor = executor;
        this.mbeanName = "org.apache.cassandra." + jmxPath + ":type=" + executor.getThreadFactory().id;
        this.metrics = new ThreadPoolMetrics(executor, jmxPath, executor.getThreadFactory().id).register();
        executor.setRejectedExecutionHandler(ThreadPoolExecutorJMXAdapter.rejectedExecutionHandler(this.metrics, executor.getRejectedExecutionHandler()));
        MBeanWrapper.instance.registerMBean((Object)this, this.mbeanName);
        executor.onShutdown(this);
    }

    @Override
    public synchronized void run() {
        if (this.released) {
            return;
        }
        MBeanWrapper.instance.unregisterMBean(this.mbeanName);
        this.metrics.release();
        this.released = true;
    }

    public ThreadPoolMetrics metrics() {
        return this.metrics;
    }

    @Override
    public int getActiveTaskCount() {
        return this.executor.getActiveTaskCount();
    }

    @Override
    public int getPendingTaskCount() {
        return this.executor.getPendingTaskCount();
    }

    @Override
    public int getCoreThreads() {
        return this.executor.getCoreThreads();
    }

    @Override
    public void setCoreThreads(int number) {
        this.executor.setCoreThreads(number);
    }

    @Override
    public int getMaximumThreads() {
        return this.executor.getMaximumThreads();
    }

    @Override
    public void setMaximumThreads(int number) {
        this.executor.setMaximumThreads(number);
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.executor.setCorePoolSize(corePoolSize);
    }

    @Override
    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.executor.setMaximumPoolSize(maximumPoolSize);
    }

    @Override
    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    @Override
    public int getMaxTasksQueued() {
        return this.executor.getMaxTasksQueued();
    }

    static RejectedExecutionHandler rejectedExecutionHandler(ThreadPoolMetrics metrics, RejectedExecutionHandler wrap) {
        return (task, executor) -> {
            metrics.totalBlocked.inc();
            metrics.currentBlocked.inc();
            try {
                wrap.rejectedExecution(task, executor);
            }
            finally {
                metrics.currentBlocked.dec();
            }
        };
    }

    static class Builder<E extends ThreadPoolExecutorBase>
    implements ExecutorBuilder<E> {
        final ExecutorBuilder<E> wrapped;
        final String jmxPath;

        Builder(ExecutorBuilder<E> wrapped, String jmxPath) {
            this.wrapped = wrapped;
            this.jmxPath = jmxPath;
        }

        @Override
        public ExecutorBuilder<E> withKeepAlive(long keepAlive, TimeUnit keepAliveUnits) {
            this.wrapped.withKeepAlive(keepAlive, keepAliveUnits);
            return this;
        }

        @Override
        public ExecutorBuilder<E> withKeepAlive() {
            this.wrapped.withKeepAlive();
            return this;
        }

        @Override
        public ExecutorBuilder<E> withThreadPriority(int threadPriority) {
            this.wrapped.withThreadPriority(threadPriority);
            return this;
        }

        @Override
        public ExecutorBuilder<E> withQueueLimit(int queueLimit) {
            this.wrapped.withQueueLimit(queueLimit);
            return this;
        }

        @Override
        public ExecutorBuilder<E> withThreadGroup(ThreadGroup threadGroup) {
            this.wrapped.withThreadGroup(threadGroup);
            return this;
        }

        @Override
        public ExecutorBuilder<E> withDefaultThreadGroup() {
            this.wrapped.withDefaultThreadGroup();
            return this;
        }

        @Override
        public ExecutorBuilder<E> withRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.wrapped.withRejectedExecutionHandler(rejectedExecutionHandler);
            return this;
        }

        @Override
        public ExecutorBuilder<E> withUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.wrapped.withUncaughtExceptionHandler(uncaughtExceptionHandler);
            return this;
        }

        @Override
        public E build() {
            ThreadPoolExecutorBase result = (ThreadPoolExecutorBase)this.wrapped.build();
            ThreadPoolExecutorJMXAdapter.register(this.jmxPath, result);
            return (E)result;
        }
    }
}

