/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.ChecksummedRandomAccessReader;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.CorruptFileException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.LengthAvailableInputStream;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.io.util.WrappedDataOutputStreamPlus;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSavingCache<K extends CacheKey, V>
extends InstrumentingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AutoSavingCache.class);
    public static final Set<CacheService.CacheType> flushInProgress = new NonBlockingHashSet();
    protected volatile ScheduledFuture<?> saveTask;
    protected final CacheService.CacheType cacheType;
    private final CacheSerializer<K, V> cacheLoader;
    private static final String CURRENT_VERSION = "f";
    private static volatile IStreamFactory streamFactory = new IStreamFactory(){
        private final SequentialWriterOption writerOption = SequentialWriterOption.newBuilder().trickleFsync(DatabaseDescriptor.getTrickleFsync()).trickleFsyncByteInterval(DatabaseDescriptor.getTrickleFsyncIntervalInKiB() * 1024).finishOnClose(true).build();

        @Override
        public InputStream getInputStream(File dataPath, File crcPath) throws IOException {
            return ChecksummedRandomAccessReader.open(dataPath, crcPath);
        }

        @Override
        public OutputStream getOutputStream(File dataPath, File crcPath) {
            return new ChecksummedSequentialWriter(dataPath, crcPath, null, this.writerOption);
        }
    };

    public static void setStreamFactory(IStreamFactory streamFactory) {
        AutoSavingCache.streamFactory = streamFactory;
    }

    public AutoSavingCache(ICache<K, V> cache, CacheService.CacheType cacheType, CacheSerializer<K, V> cacheloader) {
        super(cacheType.toString(), cache);
        this.cacheType = cacheType;
        this.cacheLoader = cacheloader;
    }

    public File getCacheDataPath(String version) {
        return DatabaseDescriptor.getSerializedCachePath(this.cacheType, version, "db");
    }

    public File getCacheCrcPath(String version) {
        return DatabaseDescriptor.getSerializedCachePath(this.cacheType, version, "crc");
    }

    public Writer getWriter(int keysToSave) {
        return new Writer(keysToSave);
    }

    public void scheduleSaving(int savePeriodInSeconds, final int keysToSave) {
        if (this.saveTask != null) {
            this.saveTask.cancel(false);
            this.saveTask = null;
        }
        if (savePeriodInSeconds > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AutoSavingCache.this.submitWrite(keysToSave);
                }
            };
            this.saveTask = ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(runnable, savePeriodInSeconds, savePeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    public Future<Integer> loadSavedAsync() {
        Object es = ExecutorFactory.Global.executorFactory().sequential("loadSavedCache");
        long start = Clock.Global.nanoTime();
        java.util.concurrent.Future cacheLoad = es.submit(this::loadSaved);
        cacheLoad.addListener(() -> {
            if (this.size() > 0) {
                logger.info("Completed loading ({} ms; {} keys) {} cache", new Object[]{TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start), CacheService.instance.keyCache.size(), this.cacheType});
            }
            es.shutdown();
        });
        return cacheLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int loadSaved() {
        File dataPath;
        long start;
        int count;
        block17: {
            count = 0;
            start = Clock.Global.nanoTime();
            dataPath = this.getCacheDataPath(CURRENT_VERSION);
            File crcPath = this.getCacheCrcPath(CURRENT_VERSION);
            if (dataPath.exists() && crcPath.exists()) {
                DataInputPlus.DataInputStreamPlus in = null;
                try {
                    logger.info("reading saved cache {}", (Object)dataPath);
                    in = new DataInputPlus.DataInputStreamPlus(new LengthAvailableInputStream(new BufferedInputStream(streamFactory.getInputStream(dataPath, crcPath)), dataPath.length()));
                    UUID schemaVersion = new UUID(in.readLong(), in.readLong());
                    if (!schemaVersion.equals(Schema.instance.getVersion())) {
                        throw new RuntimeException("Cache schema version " + schemaVersion + " does not match current schema version " + Schema.instance.getVersion());
                    }
                    ArrayDeque<Future<Pair<K, V>>> futures = new ArrayDeque<Future<Pair<K, V>>>();
                    long loadByNanos = start + TimeUnit.SECONDS.toNanos(DatabaseDescriptor.getCacheLoadTimeout());
                    while (Clock.Global.nanoTime() < loadByNanos && in.available() > 0) {
                        Future<Pair<K, V>> entryFuture;
                        TableId tableId = TableId.deserialize(in);
                        String indexName = in.readUTF();
                        if (indexName.isEmpty()) {
                            indexName = null;
                        }
                        ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(tableId);
                        if (indexName != null && cfs != null) {
                            cfs = cfs.indexManager.getIndexByName(indexName).getBackingTable().orElse(null);
                        }
                        if ((entryFuture = this.cacheLoader.deserialize(in, cfs)) == null) continue;
                        futures.offer(entryFuture);
                        ++count;
                        while (true) {
                            if (futures.peek() != null && ((Future)futures.peek()).isDone()) {
                                Future future = (Future)futures.poll();
                                Pair entry = (Pair)future.get();
                                if (entry == null || entry.right == null) continue;
                                this.put(entry.left, entry.right);
                                continue;
                            }
                            if (futures.size() > 1000) {
                                Thread.yield();
                            }
                            if (futures.size() <= 1000) break;
                        }
                    }
                    Future future = null;
                    while ((future = (Future)futures.poll()) != null) {
                        Pair entry = (Pair)future.get();
                        if (entry == null || entry.right == null) continue;
                        this.put(entry.left, entry.right);
                    }
                    FileUtils.closeQuietly(in);
                }
                catch (CorruptFileException e) {
                    JVMStabilityInspector.inspectThrowable(e);
                    logger.warn(String.format("Non-fatal checksum error reading saved cache %s", dataPath.absolutePath()), (Throwable)e);
                    break block17;
                }
                catch (Throwable t) {
                    JVMStabilityInspector.inspectThrowable(t);
                    logger.info(String.format("Harmless error reading saved cache %s", dataPath.absolutePath()), t);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    FileUtils.closeQuietly(in);
                    this.cacheLoader.cleanupAfterDeserialize();
                    break block17;
                }
                finally {
                    FileUtils.closeQuietly(in);
                    this.cacheLoader.cleanupAfterDeserialize();
                }
                this.cacheLoader.cleanupAfterDeserialize();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("completed reading ({} ms; {} keys) saved cache {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start), count, dataPath});
        }
        return count;
    }

    public Future<?> submitWrite(int keysToSave) {
        return CompactionManager.instance.submitCacheWrite(this.getWriter(keysToSave));
    }

    public static interface CacheSerializer<K extends CacheKey, V> {
        public void serialize(K var1, DataOutputPlus var2, ColumnFamilyStore var3) throws IOException;

        public Future<Pair<K, V>> deserialize(DataInputPlus var1, ColumnFamilyStore var2) throws IOException;

        default public void cleanupAfterDeserialize() {
        }
    }

    public class Writer
    extends CompactionInfo.Holder {
        private final Iterator<K> keyIterator;
        private final CompactionInfo info;
        private long keysWritten;
        private final long keysEstimate;

        protected Writer(int keysToSave) {
            int size = AutoSavingCache.this.size();
            if (keysToSave >= size || keysToSave == 0) {
                this.keyIterator = AutoSavingCache.this.keyIterator();
                this.keysEstimate = size;
            } else {
                this.keyIterator = AutoSavingCache.this.hotKeyIterator(keysToSave);
                this.keysEstimate = keysToSave;
            }
            OperationType type = AutoSavingCache.this.cacheType == CacheService.CacheType.KEY_CACHE ? OperationType.KEY_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.ROW_CACHE ? OperationType.ROW_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.COUNTER_CACHE ? OperationType.COUNTER_CACHE_SAVE : OperationType.UNKNOWN));
            this.info = CompactionInfo.withoutSSTables(TableMetadata.minimal("system", AutoSavingCache.this.cacheType.toString()), type, 0L, this.keysEstimate, CompactionInfo.Unit.KEYS, TimeUUID.Generator.nextTimeUUID());
        }

        public CacheService.CacheType cacheType() {
            return AutoSavingCache.this.cacheType;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            return this.info.forProgress(this.keysWritten, Math.max(this.keysWritten, this.keysEstimate));
        }

        public void saveCache() {
            logger.trace("Deleting old {} files.", (Object)AutoSavingCache.this.cacheType);
            this.deleteOldCacheFiles();
            if (!this.keyIterator.hasNext()) {
                logger.trace("Skipping {} save, cache is empty.", (Object)AutoSavingCache.this.cacheType);
                return;
            }
            long start = Clock.Global.nanoTime();
            Pair<File, File> cacheFilePaths = this.tempCacheFiles();
            try (WrappedDataOutputStreamPlus writer = new WrappedDataOutputStreamPlus(streamFactory.getOutputStream((File)cacheFilePaths.left, (File)cacheFilePaths.right));){
                UUID schemaVersion = Schema.instance.getVersion();
                writer.writeLong(schemaVersion.getMostSignificantBits());
                writer.writeLong(schemaVersion.getLeastSignificantBits());
                while (this.keyIterator.hasNext()) {
                    CacheKey key = (CacheKey)this.keyIterator.next();
                    ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(key.tableId);
                    if (cfs == null) continue;
                    if (key.indexName != null) {
                        cfs = cfs.indexManager.getIndexByName(key.indexName).getBackingTable().orElse(null);
                    }
                    AutoSavingCache.this.cacheLoader.serialize(key, writer, cfs);
                    ++this.keysWritten;
                    if (this.keysWritten < this.keysEstimate) continue;
                    break;
                }
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, (File)cacheFilePaths.left);
            }
            File cacheFile = AutoSavingCache.this.getCacheDataPath(AutoSavingCache.CURRENT_VERSION);
            File crcFile = AutoSavingCache.this.getCacheCrcPath(AutoSavingCache.CURRENT_VERSION);
            cacheFile.tryDelete();
            crcFile.tryDelete();
            if (!((File)cacheFilePaths.left).tryMove(cacheFile)) {
                logger.error("Unable to rename {} to {}", cacheFilePaths.left, (Object)cacheFile);
            }
            if (!((File)cacheFilePaths.right).tryMove(crcFile)) {
                logger.error("Unable to rename {} to {}", cacheFilePaths.right, (Object)crcFile);
            }
            logger.info("Saved {} ({} items) in {} ms", new Object[]{AutoSavingCache.this.cacheType, this.keysWritten, TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start)});
        }

        private Pair<File, File> tempCacheFiles() {
            File dataPath = AutoSavingCache.this.getCacheDataPath(AutoSavingCache.CURRENT_VERSION);
            File crcPath = AutoSavingCache.this.getCacheCrcPath(AutoSavingCache.CURRENT_VERSION);
            return Pair.create(FileUtils.createTempFile(dataPath.name(), null, dataPath.parent()), FileUtils.createTempFile(crcPath.name(), null, crcPath.parent()));
        }

        private void deleteOldCacheFiles() {
            File savedCachesDir = new File(DatabaseDescriptor.getSavedCachesLocation());
            assert (savedCachesDir.exists() && savedCachesDir.isDirectory());
            File[] files = savedCachesDir.tryList();
            if (files != null) {
                String cacheNameFormat = String.format("%s-%s.db", AutoSavingCache.this.cacheType.toString(), AutoSavingCache.CURRENT_VERSION);
                for (File file : files) {
                    if (!file.isFile() || !file.name().endsWith(cacheNameFormat) && !file.name().endsWith(AutoSavingCache.this.cacheType.toString()) || file.tryDelete()) continue;
                    logger.warn("Failed to delete {}", (Object)file.absolutePath());
                }
            } else {
                logger.warn("Could not list files in {}", (Object)savedCachesDir);
            }
        }

        @Override
        public boolean isGlobal() {
            return false;
        }
    }

    public static interface IStreamFactory {
        public InputStream getInputStream(File var1, File var2) throws IOException;

        public OutputStream getOutputStream(File var1, File var2);
    }
}

