/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import net.nmoncho.shaded.com.google.common.base.Objects;
import net.nmoncho.shaded.com.google.common.collect.ComparisonChain;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;

public class PermissionDetails
implements Comparable<PermissionDetails> {
    public final String grantee;
    public final IResource resource;
    public final Permission permission;

    public PermissionDetails(String grantee, IResource resource, Permission permission) {
        this.grantee = grantee;
        this.resource = resource;
        this.permission = permission;
    }

    @Override
    public int compareTo(PermissionDetails other) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.grantee), (Comparable<?>)((Object)other.grantee)).compare((Comparable<?>)((Object)this.resource.getName()), (Comparable<?>)((Object)other.resource.getName())).compare((Comparable<?>)((Object)this.permission), (Comparable<?>)((Object)other.permission)).result();
    }

    public String toString() {
        return String.format("<PermissionDetails grantee:%s resource:%s permission:%s>", new Object[]{this.grantee, this.resource.getName(), this.permission});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PermissionDetails)) {
            return false;
        }
        PermissionDetails pd = (PermissionDetails)o;
        return Objects.equal(this.grantee, pd.grantee) && Objects.equal(this.resource, pd.resource) && Objects.equal((Object)this.permission, (Object)pd.permission);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.grantee, this.resource, this.permission});
    }
}

