/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.AuthCacheMBean;
import org.apache.cassandra.auth.AuthCacheService;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.CassandraAuthorizer;
import org.apache.cassandra.auth.CassandraRoleManager;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthenticator
implements IAuthenticator,
AuthCache.BulkLoader<String, String> {
    private static final Logger logger = LoggerFactory.getLogger(PasswordAuthenticator.class);
    private static final String NO_SUCH_CREDENTIAL = "";
    private static final String SALTED_HASH = "salted_hash";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    static final byte NUL = 0;
    private SelectStatement authenticateStatement;
    private final CredentialsCache cache = new CredentialsCache(this);

    public PasswordAuthenticator() {
        AuthCacheService.instance.register(this.cache);
    }

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    @Override
    public Supplier<Map<String, String>> bulkLoader() {
        return () -> {
            HashMap entries = new HashMap();
            logger.info("Pre-warming credentials cache from roles table");
            UntypedResultSet results = this.process("SELECT role, salted_hash FROM system_auth.roles", CassandraAuthorizer.authReadConsistencyLevel());
            results.forEach(row -> {
                if (row.has(SALTED_HASH)) {
                    entries.put(row.getString("role"), row.getString(SALTED_HASH));
                }
            });
            return entries;
        };
    }

    public CredentialsCache getCredentialsCache() {
        return this.cache;
    }

    protected static boolean checkpw(String password, String hash) {
        try {
            return BCrypt.checkpw((String)password, (String)hash);
        }
        catch (Exception e) {
            logger.warn("Error: invalid password hash encountered, rejecting user", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    UntypedResultSet process(String query, ConsistencyLevel cl) {
        return QueryProcessor.process(query, cl);
    }

    private AuthenticatedUser authenticate(String username, String password) throws AuthenticationException {
        String hash = (String)this.cache.get(username);
        if (hash == NO_SUCH_CREDENTIAL) {
            this.cache.invalidateCredentials(username);
            throw new AuthenticationException(String.format("Provided username %s and/or password are incorrect", username));
        }
        if (!PasswordAuthenticator.checkpw(password, hash)) {
            throw new AuthenticationException(String.format("Provided username %s and/or password are incorrect", username));
        }
        return new AuthenticatedUser(username);
    }

    private String queryHashedPassword(String username) {
        try {
            QueryOptions options = QueryOptions.forInternalCalls(CassandraRoleManager.consistencyForRoleRead(username), Lists.newArrayList(ByteBufferUtil.bytes(username)));
            ResultMessage.Rows rows = this.select(this.authenticateStatement, options);
            if (rows.result.isEmpty()) {
                return NO_SUCH_CREDENTIAL;
            }
            UntypedResultSet result = UntypedResultSet.create(rows.result);
            if (!result.one().has(SALTED_HASH)) {
                return NO_SUCH_CREDENTIAL;
            }
            return result.one().getString(SALTED_HASH);
        }
        catch (RequestExecutionException e) {
            throw new AuthenticationException("Unable to perform authentication: " + e.getMessage(), e);
        }
    }

    @VisibleForTesting
    ResultMessage.Rows select(SelectStatement statement, QueryOptions options) {
        return statement.execute(QueryState.forInternalCalls(), options, Dispatcher.RequestTime.forImmediateExecution());
    }

    public Set<DataResource> protectedResources() {
        return ImmutableSet.of(DataResource.table("system_auth", "roles"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        String query = String.format("SELECT %s FROM %s.%s WHERE role = ?", SALTED_HASH, "system_auth", "roles");
        this.authenticateStatement = PasswordAuthenticator.prepare(query);
    }

    @Override
    public AuthenticatedUser legacyAuthenticate(Map<String, String> credentials) throws AuthenticationException {
        String username = credentials.get(USERNAME_KEY);
        if (username == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing", USERNAME_KEY));
        }
        String password = credentials.get(PASSWORD_KEY);
        if (password == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing for provided username %s", PASSWORD_KEY, username));
        }
        return this.authenticate(username, password);
    }

    @Override
    public IAuthenticator.SaslNegotiator newSaslNegotiator(InetAddress clientAddress) {
        return new PlainTextSaslAuthenticator();
    }

    private static SelectStatement prepare(String query) {
        return (SelectStatement)QueryProcessor.getStatement(query, ClientState.forInternalCalls());
    }

    public static interface CredentialsCacheMBean
    extends AuthCacheMBean {
        public static final String CACHE_NAME = "CredentialsCache";

        public void invalidateCredentials(String var1);
    }

    public static class CredentialsCache
    extends AuthCache<String, String>
    implements CredentialsCacheMBean {
        private CredentialsCache(PasswordAuthenticator authenticator) {
            super("CredentialsCache", DatabaseDescriptor::setCredentialsValidity, DatabaseDescriptor::getCredentialsValidity, DatabaseDescriptor::setCredentialsUpdateInterval, DatabaseDescriptor::getCredentialsUpdateInterval, DatabaseDescriptor::setCredentialsCacheMaxEntries, DatabaseDescriptor::getCredentialsCacheMaxEntries, DatabaseDescriptor::setCredentialsCacheActiveUpdate, DatabaseDescriptor::getCredentialsCacheActiveUpdate, x$0 -> authenticator.queryHashedPassword(x$0), authenticator.bulkLoader(), () -> true, (k, v) -> PasswordAuthenticator.NO_SUCH_CREDENTIAL == v);
        }

        @Override
        public void invalidateCredentials(String roleName) {
            this.invalidate(roleName);
        }
    }

    private class PlainTextSaslAuthenticator
    implements IAuthenticator.SaslNegotiator {
        private boolean complete = false;
        private String username;
        private String password;

        private PlainTextSaslAuthenticator() {
        }

        @Override
        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            this.decodeCredentials(clientResponse);
            this.complete = true;
            return null;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            if (!this.complete) {
                throw new AuthenticationException("SASL negotiation not complete");
            }
            return PasswordAuthenticator.this.authenticate(this.username, this.password);
        }

        private void decodeCredentials(byte[] bytes) throws AuthenticationException {
            logger.trace("Decoding credentials from client token");
            byte[] user = null;
            byte[] pass = null;
            int end = bytes.length;
            for (int i = bytes.length - 1; i >= 0; --i) {
                if (bytes[i] != 0) continue;
                if (pass == null) {
                    pass = Arrays.copyOfRange(bytes, i + 1, end);
                } else if (user == null) {
                    user = Arrays.copyOfRange(bytes, i + 1, end);
                } else {
                    throw new AuthenticationException("Credential format error: username or password is empty or contains NUL(\\0) character");
                }
                end = i;
            }
            if (pass == null || pass.length == 0) {
                throw new AuthenticationException("Password must not be null");
            }
            if (user == null || user.length == 0) {
                throw new AuthenticationException("Authentication ID must not be null");
            }
            this.username = new String(user, StandardCharsets.UTF_8);
            this.password = new String(pass, StandardCharsets.UTF_8);
        }
    }
}

