/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import net.nmoncho.shaded.com.google.common.collect.Sets;
import org.apache.cassandra.dht.Datacenters;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class DCPermissions {
    private static final DCPermissions ALL = new DCPermissions(){

        @Override
        public boolean canAccess(String dc) {
            return true;
        }

        @Override
        public boolean restrictsAccess() {
            return false;
        }

        @Override
        public Set<String> allowedDCs() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ALL";
        }

        @Override
        public void validate() {
        }
    };
    private static final DCPermissions NONE = new DCPermissions(){

        @Override
        public boolean canAccess(String dc) {
            return false;
        }

        @Override
        public boolean restrictsAccess() {
            return true;
        }

        @Override
        public Set<String> allowedDCs() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "n/a";
        }

        @Override
        public void validate() {
            throw new UnsupportedOperationException();
        }
    };

    public abstract boolean canAccess(String var1);

    public abstract boolean restrictsAccess();

    public abstract Set<String> allowedDCs();

    public abstract void validate();

    public static DCPermissions all() {
        return ALL;
    }

    public static DCPermissions none() {
        return NONE;
    }

    public static DCPermissions subset(Set<String> dcs) {
        return new SubsetPermissions(dcs);
    }

    public static DCPermissions subset(String ... dcs) {
        return DCPermissions.subset(Sets.newHashSet(dcs));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> dcs = new HashSet<String>();
        private boolean isAll = false;
        private boolean modified = false;

        public void add(String dc) {
            Preconditions.checkArgument(!this.isAll, "All has been set");
            this.dcs.add(dc);
            this.modified = true;
        }

        public void all() {
            Preconditions.checkArgument(this.dcs.isEmpty(), "DCs have already been set");
            this.isAll = true;
            this.modified = true;
        }

        public boolean isModified() {
            return this.modified;
        }

        public DCPermissions build() {
            if (this.dcs.isEmpty()) {
                return DCPermissions.all();
            }
            return DCPermissions.subset(this.dcs);
        }
    }

    private static class SubsetPermissions
    extends DCPermissions {
        private final Set<String> subset;

        public SubsetPermissions(Set<String> subset) {
            Preconditions.checkNotNull(subset);
            this.subset = subset;
        }

        @Override
        public boolean canAccess(String dc) {
            return this.subset.contains(dc);
        }

        @Override
        public boolean restrictsAccess() {
            return true;
        }

        @Override
        public Set<String> allowedDCs() {
            return ImmutableSet.copyOf(this.subset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubsetPermissions that = (SubsetPermissions)o;
            return this.subset.equals(that.subset);
        }

        public int hashCode() {
            return this.subset.hashCode();
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ");
            this.subset.forEach(joiner::add);
            return joiner.toString();
        }

        @Override
        public void validate() {
            Sets.SetView<String> unknownDcs = Sets.difference(this.subset, Datacenters.getValidDatacenters());
            if (!unknownDcs.isEmpty()) {
                throw new InvalidRequestException(String.format("Invalid value(s) for DATACENTERS '%s',All values must be valid datacenters", this.subset));
            }
        }
    }
}

