/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRefresher<K, V>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CacheRefresher.class);
    private final String name;
    private final LoadingCache<K, V> cache;
    private final BiPredicate<K, V> invalidationCondition;
    private final BooleanSupplier skipCondition;

    private CacheRefresher(String name, LoadingCache<K, V> cache, BiPredicate<K, V> invalidationCondition, BooleanSupplier skipCondition) {
        this.name = name;
        this.cache = cache;
        this.invalidationCondition = invalidationCondition;
        this.skipCondition = skipCondition;
    }

    @Override
    public void run() {
        if (this.skipCondition.getAsBoolean()) {
            logger.debug("Skipping {} cache refresh", (Object)this.name);
            return;
        }
        try {
            logger.debug("Refreshing {} cache", (Object)this.name);
            Set ks = this.cache.asMap().keySet();
            for (Object key : ks) {
                this.cache.refresh(key);
                Object value = this.cache.getIfPresent(key);
                if (!this.invalidationCondition.test(key, value)) continue;
                logger.debug("Invalidating key");
                this.cache.invalidate(key);
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception refreshing {} cache", (Object)this.name, (Object)e);
        }
    }

    @VisibleForTesting
    public static <K, V> CacheRefresher<K, V> create(String name, LoadingCache<K, V> cache, BiPredicate<K, V> invalidationCondition, BooleanSupplier skipCondition) {
        logger.info("Creating CacheRefresher for {}", (Object)name);
        return new CacheRefresher<K, V>(name, cache, invalidationCondition, skipCondition);
    }

    public static <K, V> CacheRefresher<K, V> create(String name, LoadingCache<K, V> cache, BiPredicate<K, V> invalidationCondition) {
        return CacheRefresher.create(name, cache, invalidationCondition, StorageService.instance::isDecommissioned);
    }
}

