/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.cql3.QueryEvents;
import org.apache.cassandra.service.QueryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthEvents {
    private static final Logger logger = LoggerFactory.getLogger(QueryEvents.class);
    public static final AuthEvents instance = new AuthEvents();
    private final Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    @VisibleForTesting
    public int listenerCount() {
        return this.listeners.size();
    }

    public void registerListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyAuthSuccess(QueryState state) {
        try {
            for (Listener listener : this.listeners) {
                listener.authSuccess(state);
            }
        }
        catch (Exception e) {
            logger.error("Failed notifying listeners", (Throwable)e);
        }
    }

    public void notifyAuthFailure(QueryState state, Exception cause) {
        try {
            for (Listener listener : this.listeners) {
                listener.authFailure(state, cause);
            }
        }
        catch (Exception e) {
            logger.error("Failed notifying listeners", (Throwable)e);
        }
    }

    public static interface Listener {
        public void authSuccess(QueryState var1);

        public void authFailure(QueryState var1, Exception var2);
    }
}

