/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.base.Strings;
import org.apache.cassandra.audit.AuditLogEntryCategory;
import org.apache.cassandra.audit.BinAuditLogger;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.binlog.BinLogOptions;

public class AuditLogOptions
extends BinLogOptions {
    public volatile boolean enabled = false;
    public ParameterizedClass logger = new ParameterizedClass(BinAuditLogger.class.getSimpleName(), Collections.emptyMap());
    public String included_keyspaces = "";
    public String excluded_keyspaces = "system,system_schema,system_virtual_schema";
    public String included_categories = "";
    public String excluded_categories = "";
    public String included_users = "";
    public String excluded_users = "";
    public String audit_logs_dir;

    public AuditLogOptions() {
        String auditLogDir = CassandraRelevantProperties.LOG_DIR_AUDIT.getString();
        String logDir = CassandraRelevantProperties.LOG_DIR.getString() + "/audit";
        Path path = auditLogDir == null ? File.getPath(logDir, new String[0]) : File.getPath(auditLogDir, new String[0]);
        this.audit_logs_dir = path.normalize().toString();
    }

    public static AuditLogOptions validate(AuditLogOptions options) throws ConfigurationException {
        AuditLogOptions.validateCategories(options.included_categories);
        AuditLogOptions.validateCategories(options.excluded_categories);
        return options;
    }

    private static void validateCategories(String categories) {
        assert (categories != null);
        if (categories.isEmpty()) {
            return;
        }
        for (String includedCategory : categories.split(",")) {
            try {
                AuditLogEntryCategory.valueOf(includedCategory);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException(String.format("category %s not found in %s", includedCategory, AuditLogEntryCategory.class.getName()), ex);
            }
        }
    }

    public String toString() {
        return "AuditLogOptions{enabled=" + this.enabled + ", logger='" + this.logger + '\'' + ", included_keyspaces='" + this.included_keyspaces + '\'' + ", excluded_keyspaces='" + this.excluded_keyspaces + '\'' + ", included_categories='" + this.included_categories + '\'' + ", excluded_categories='" + this.excluded_categories + '\'' + ", included_users='" + this.included_users + '\'' + ", excluded_users='" + this.excluded_users + '\'' + ", audit_logs_dir='" + this.audit_logs_dir + '\'' + ", archive_command='" + this.archive_command + '\'' + ", roll_cycle='" + this.roll_cycle + '\'' + ", block=" + this.block + ", max_queue_weight=" + this.max_queue_weight + ", max_log_size=" + this.max_log_size + ", max_archive_retries=" + this.max_archive_retries + '}';
    }

    public static class Builder {
        private boolean enabled;
        private ParameterizedClass logger;
        private String includedKeyspaces;
        private String excludedKeyspaces;
        private String includedCategories;
        private String excludedCategories;
        private String includedUsers;
        private String excludedUsers;
        private String auditLogDir;
        private int maxQueueWeight;
        private int maxArchiveRetries;
        private String rollCycle;
        private String archiveCommand;
        private boolean block;
        private long maxLogSize;

        public Builder() {
            this(new AuditLogOptions());
        }

        public Builder(AuditLogOptions opts) {
            this.enabled = opts.enabled;
            this.logger = opts.logger;
            this.includedKeyspaces = opts.included_keyspaces;
            this.excludedKeyspaces = opts.excluded_keyspaces;
            this.includedCategories = opts.included_categories;
            this.excludedCategories = opts.excluded_categories;
            this.includedUsers = opts.included_users;
            this.excludedUsers = opts.excluded_users;
            this.auditLogDir = opts.audit_logs_dir;
            this.maxQueueWeight = opts.max_queue_weight;
            this.maxArchiveRetries = opts.max_archive_retries;
            this.rollCycle = opts.roll_cycle;
            this.archiveCommand = opts.archive_command;
            this.block = opts.block;
            this.maxLogSize = opts.max_log_size;
        }

        public Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder withLogger(String loggerName, Map<String, String> parameters) {
            if (loggerName != null && !loggerName.trim().isEmpty()) {
                this.logger = new ParameterizedClass(loggerName.trim(), parameters);
            }
            return this;
        }

        public Builder withIncludedKeyspaces(String includedKeyspaces) {
            Builder.sanitise(includedKeyspaces).map(v -> {
                this.includedKeyspaces = v;
                return this.includedKeyspaces;
            });
            return this;
        }

        public Builder withExcludedKeyspaces(String excludedKeyspaces) {
            Builder.sanitise(excludedKeyspaces).map(v -> {
                this.excludedKeyspaces = v;
                return this.excludedKeyspaces;
            });
            return this;
        }

        public Builder withIncludedCategories(String includedCategories) {
            Builder.sanitise(includedCategories).map(v -> {
                this.includedCategories = v.toUpperCase();
                return this.includedCategories;
            });
            return this;
        }

        public Builder withExcludedCategories(String excludedCategories) {
            Builder.sanitise(excludedCategories).map(v -> {
                this.excludedCategories = v.toUpperCase();
                return this.excludedCategories;
            });
            return this;
        }

        public Builder withIncludedUsers(String includedUsers) {
            Builder.sanitise(includedUsers).map(v -> {
                this.includedUsers = v;
                return this.includedUsers;
            });
            return this;
        }

        public Builder withExcludedUsers(String excludedUsers) {
            Builder.sanitise(excludedUsers).map(v -> {
                this.excludedUsers = v;
                return this.excludedUsers;
            });
            return this;
        }

        public Builder withAuditLogDir(String auditLogDir) {
            this.auditLogDir = auditLogDir;
            return this;
        }

        public Builder withRollCycle(String rollCycle) {
            Builder.sanitise(rollCycle).map(v -> {
                this.rollCycle = v.toUpperCase();
                return this.rollCycle;
            });
            return this;
        }

        public Builder withArchiveCommand(String archiveCommand) {
            if (archiveCommand != null) {
                this.archiveCommand = archiveCommand;
            }
            return this;
        }

        public Builder withBlock(Boolean block) {
            if (block != null) {
                this.block = block;
            }
            return this;
        }

        public Builder withMaxLogSize(long maxLogSize) {
            if (maxLogSize != Long.MIN_VALUE) {
                this.maxLogSize = maxLogSize;
            }
            return this;
        }

        public Builder withMaxArchiveRetries(int maxArchiveRetries) {
            if (maxArchiveRetries != Integer.MIN_VALUE) {
                this.maxArchiveRetries = maxArchiveRetries;
            }
            return this;
        }

        public Builder withMaxQueueWeight(int maxQueueWeight) {
            if (maxQueueWeight != Integer.MIN_VALUE) {
                this.maxQueueWeight = maxQueueWeight;
            }
            return this;
        }

        public AuditLogOptions build() {
            AuditLogOptions opts = new AuditLogOptions();
            opts.enabled = this.enabled;
            opts.logger = this.logger;
            Builder.sanitise(this.includedKeyspaces).map(v -> {
                opts.included_keyspaces = v;
                return opts.included_keyspaces;
            });
            Builder.sanitise(this.excludedKeyspaces).map(v -> {
                opts.excluded_keyspaces = v;
                return opts.excluded_keyspaces;
            });
            Builder.sanitise(this.includedCategories).map(v -> {
                opts.included_categories = v.toUpperCase();
                return opts.included_categories;
            });
            Builder.sanitise(this.excludedCategories).map(v -> {
                opts.excluded_categories = v.toUpperCase();
                return opts.excluded_categories;
            });
            Builder.sanitise(this.includedUsers).map(v -> {
                opts.included_users = v;
                return opts.included_users;
            });
            Builder.sanitise(this.excludedUsers).map(v -> {
                opts.excluded_users = v;
                return opts.excluded_users;
            });
            opts.roll_cycle = this.rollCycle;
            opts.audit_logs_dir = this.auditLogDir;
            opts.max_queue_weight = this.maxQueueWeight;
            opts.max_archive_retries = this.maxArchiveRetries;
            opts.archive_command = this.archiveCommand;
            opts.block = this.block;
            opts.max_log_size = this.maxLogSize;
            AuditLogOptions.validate(opts);
            return opts;
        }

        private static Optional<String> sanitise(String input) {
            if (input == null || input.trim().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Arrays.stream(input.split(",")).map(String::trim).map(Strings::emptyToNull).filter(Objects::nonNull).collect(Collectors.joining(",")));
        }
    }
}

