/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.utils;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nmoncho.utils.CqlOperations;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class EmbeddedCassandraServerHelper {
    private static Logger log = LoggerFactory.getLogger(EmbeddedCassandraServerHelper.class);
    public static final long DEFAULT_STARTUP_TIMEOUT = 200000L;
    public static final String DEFAULT_TMP_DIR = "target/embeddedCassandra";
    public static final String DEFAULT_CASSANDRA_YML_FILE = "cu-cassandra.yaml";
    public static final String CASSANDRA_RNDPORT_YML_FILE = "cu-cassandra-rndport.yaml";
    public static final String DEFAULT_LOG4J_CONFIG_FILE = "/log4j-embedded-cassandra.properties";
    private static final String INTERNAL_CASSANDRA_KEYSPACE = "system";
    private static final String INTERNAL_CASSANDRA_AUTH_KEYSPACE = "system_auth";
    private static final String INTERNAL_CASSANDRA_DISTRIBUTED_KEYSPACE = "system_distributed";
    private static final String INTERNAL_CASSANDRA_SCHEMA_KEYSPACE = "system_schema";
    private static final String INTERNAL_CASSANDRA_TRACES_KEYSPACE = "system_traces";
    private static final String INTERNAL_CASSANDRA_VIEWS_KEYSPACE = "system_views";
    private static final String INTERNAL_CASSANDRA_VIRTUAL_SCHEMA_KEYSPACE = "system_virtual_schema";
    private static final Set<String> systemKeyspaces = new HashSet<String>(Arrays.asList("system", "system_auth", "system_distributed", "system_schema", "system_traces", "system_views", "system_virtual_schema"));
    private static CassandraDaemon cassandraDaemon = null;
    private static String launchedYamlFile;
    private static CqlSession session;

    public static Predicate<String> nonSystemKeyspaces() {
        return keyspace -> !systemKeyspaces.contains(keyspace);
    }

    public static void startEmbeddedCassandra() throws IOException, InterruptedException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(200000L);
    }

    public static void startEmbeddedCassandra(long timeout) throws ConfigurationException, IOException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(DEFAULT_CASSANDRA_YML_FILE, timeout);
    }

    public static void startEmbeddedCassandra(String yamlFile) throws IOException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(yamlFile, 200000L);
    }

    public static void startEmbeddedCassandra(String yamlFile, long timeout) throws IOException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(yamlFile, DEFAULT_TMP_DIR, timeout);
    }

    public static void startEmbeddedCassandra(String yamlFile, String tmpDir) throws IOException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(yamlFile, tmpDir, 200000L);
    }

    public static void startEmbeddedCassandra(String yamlFile, String tmpDir, long timeout) throws IOException, ConfigurationException {
        if (cassandraDaemon != null) {
            return;
        }
        if (!StringUtils.startsWith((CharSequence)yamlFile, (CharSequence)"/")) {
            yamlFile = "/" + yamlFile;
        }
        EmbeddedCassandraServerHelper.rmdir(tmpDir);
        File file = EmbeddedCassandraServerHelper.copy(yamlFile, tmpDir).toFile();
        EmbeddedCassandraServerHelper.readAndAdaptYaml(file);
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(file, tmpDir, timeout);
    }

    public static void startEmbeddedCassandra(File file, long timeout) throws IOException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(file, DEFAULT_TMP_DIR, timeout);
    }

    public static void startEmbeddedCassandra(File file, String tmpDir, long timeout) throws IOException, ConfigurationException {
        if (cassandraDaemon != null) {
            return;
        }
        EmbeddedCassandraServerHelper.checkConfigNameForRestart(file.getAbsolutePath());
        log.debug("Starting cassandra...");
        log.debug("Initialization needed");
        String cassandraConfigFilePath = file.getAbsolutePath();
        cassandraConfigFilePath = String.valueOf(cassandraConfigFilePath.startsWith("/") ? "file://" : "file:/") + cassandraConfigFilePath;
        System.setProperty("cassandra.config", cassandraConfigFilePath);
        System.setProperty("cassandra-foreground", "true");
        System.setProperty("cassandra.native.epoll.enabled", "false");
        System.setProperty("cassandra.unsafesystem", "true");
        if (System.getProperty("log4j.configuration") == null) {
            EmbeddedCassandraServerHelper.copy(DEFAULT_LOG4J_CONFIG_FILE, tmpDir);
            String log4jConfiguration = "file:/" + tmpDir + DEFAULT_LOG4J_CONFIG_FILE;
            System.setProperty("log4j.configuration", log4jConfiguration);
        }
        DatabaseDescriptor.daemonInitialization();
        EmbeddedCassandraServerHelper.cleanupAndLeaveDirs();
        CountDownLatch startupLatch = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            cassandraDaemon = new CassandraDaemon();
            cassandraDaemon.activate();
            startupLatch.countDown();
        });
        try {
            try {
                if (!startupLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                    log.error("Cassandra daemon did not start after " + timeout + " ms. Consider increasing the timeout");
                    throw new AssertionError((Object)"Cassandra daemon did not start within timeout");
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (session != null) {
                        session.close();
                    }
                }));
            }
            catch (InterruptedException e) {
                log.error("Interrupted waiting for Cassandra daemon to start:", (Throwable)e);
                throw new AssertionError((Object)e);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private static void checkConfigNameForRestart(String yamlFile) {
        boolean wasPreviouslyLaunched;
        boolean bl = wasPreviouslyLaunched = launchedYamlFile != null;
        if (wasPreviouslyLaunched && !launchedYamlFile.equals(yamlFile)) {
            throw new UnsupportedOperationException("We can't launch two Cassandra configurations in the same JVM instance");
        }
        launchedYamlFile = yamlFile;
    }

    @Deprecated
    public static void stopEmbeddedCassandra() {
        log.warn("EmbeddedCassandraServerHelper.stopEmbeddedCassandra() is now deprecated, previous version was not fully operating");
        cassandraDaemon.deactivate();
    }

    public static void cleanEmbeddedCassandra() {
        if (session != null) {
            EmbeddedCassandraServerHelper.dropKeyspaces();
        }
    }

    public static void cleanDataEmbeddedCassandra(String keyspace, String ... excludedTables) {
        if (session != null) {
            EmbeddedCassandraServerHelper.cleanDataWithNativeDriver(keyspace, excludedTables);
        }
    }

    public static CqlSession getSession() {
        EmbeddedCassandraServerHelper.initSession();
        return session;
    }

    private static synchronized void initSession() {
        if (session == null) {
            DriverConfigLoader configLoader = ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)DriverConfigLoader.programmaticBuilder().withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(0L))).withInt((DriverOption)DefaultDriverOption.METADATA_SCHEMA_MAX_EVENTS, 1)).build();
            session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(EmbeddedCassandraServerHelper.getHost(), EmbeddedCassandraServerHelper.getNativeTransportPort()))).withConfigLoader(configLoader)).withLocalDatacenter("datacenter1")).build();
        }
    }

    public static String getClusterName() {
        return DatabaseDescriptor.getClusterName();
    }

    public static String getHost() {
        return DatabaseDescriptor.getRpcAddress().getHostName();
    }

    public static int getNativeTransportPort() {
        return DatabaseDescriptor.getNativeTransportPort();
    }

    private static void cleanDataWithNativeDriver(String keyspace, String ... excludedTables) {
        HashSet<String> excludedTableList = new HashSet<String>(Arrays.asList(excludedTables));
        ((KeyspaceMetadata)session.getMetadata().getKeyspace(keyspace).get()).getTables().values().stream().map(table -> table.getName()).filter(tableName -> !excludedTableList.contains(tableName)).map(tableName -> String.valueOf(keyspace) + "." + tableName).forEach(CqlOperations.truncateTable(session));
    }

    private static void dropKeyspaces() {
        EmbeddedCassandraServerHelper.dropKeyspacesWithNativeDriver();
    }

    private static void dropKeyspacesWithNativeDriver() {
        session.getMetadata().getKeyspaces().values().stream().map(keyspaceMetadata -> keyspaceMetadata.getName().toString()).filter(EmbeddedCassandraServerHelper.nonSystemKeyspaces()).forEach(CqlOperations.dropKeyspace(session));
    }

    private static void deleteRecursive(File dir) {
        File[] children;
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory() && (children = dir.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                EmbeddedCassandraServerHelper.deleteRecursive(child);
                ++n2;
            }
        }
        try {
            Files.delete(dir.toPath());
        }
        catch (Throwable t) {
            throw new FSWriteError(t, dir.toPath());
        }
    }

    private static void rmdir(String dir) {
        EmbeddedCassandraServerHelper.deleteRecursive(new File(dir));
    }

    private static Path copy(String resource, String directory) throws IOException {
        EmbeddedCassandraServerHelper.mkdir(directory);
        String fileName = resource.substring(resource.lastIndexOf("/") + 1);
        InputStream from = EmbeddedCassandraServerHelper.class.getResourceAsStream(resource);
        Path copyName = Paths.get(directory, fileName);
        Files.copy(from, copyName, new CopyOption[0]);
        return copyName;
    }

    private static void mkdir(String dir) {
        File dirFile = new File(dir);
        if (!dirFile.exists() && !dirFile.mkdirs()) {
            throw new FSWriteError((Throwable)new IOException("Failed to mkdirs " + dir), dir);
        }
    }

    private static void cleanupAndLeaveDirs() throws IOException {
        EmbeddedCassandraServerHelper.mkdirs();
        EmbeddedCassandraServerHelper.cleanup();
        EmbeddedCassandraServerHelper.mkdirs();
        CommitLog commitLog = CommitLog.instance;
        commitLog.resetUnsafe(true);
    }

    private static void cleanup() {
        ArrayList<String> directories = new ArrayList<String>(Arrays.asList(DatabaseDescriptor.getAllDataFileLocations()));
        directories.add(DatabaseDescriptor.getCommitLogLocation());
        for (String dirName : directories) {
            File dir = new File(dirName);
            if (!dir.exists()) {
                throw new RuntimeException("No such directory: " + dir.getAbsolutePath());
            }
            EmbeddedCassandraServerHelper.rmdir(dirName);
        }
    }

    public static void mkdirs() {
        DatabaseDescriptor.createAllDirectories();
    }

    private static void readAndAdaptYaml(File cassandraConfig) throws IOException {
        String yaml = EmbeddedCassandraServerHelper.readYamlFileToString(cassandraConfig);
        Pattern portPattern = Pattern.compile("^([a-z_]+)_port:\\s*([0-9]+)\\s*$", 8);
        Matcher portMatcher = portPattern.matcher(yaml);
        StringBuffer sb = new StringBuffer();
        boolean replaced = false;
        while (portMatcher.find()) {
            String replacement;
            String portName = portMatcher.group(1);
            int portValue = Integer.parseInt(portMatcher.group(2));
            if (portValue == 0) {
                portValue = EmbeddedCassandraServerHelper.findUnusedLocalPort();
                replacement = String.valueOf(portName) + "_port: " + portValue;
                replaced = true;
            } else {
                replacement = portMatcher.group(0);
            }
            portMatcher.appendReplacement(sb, replacement);
        }
        portMatcher.appendTail(sb);
        if (replaced) {
            EmbeddedCassandraServerHelper.writeStringToYamlFile(cassandraConfig, sb.toString());
        }
    }

    private static String readYamlFileToString(File yamlFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (UnicodeReader reader = new UnicodeReader((InputStream)new FileInputStream(yamlFile));){
            StringBuilder sb = new StringBuilder();
            char[] cbuf = new char[1024];
            int readden = reader.read(cbuf);
            while (readden >= 0) {
                sb.append(cbuf, 0, readden);
                readden = reader.read(cbuf);
            }
            return sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeStringToYamlFile(File yamlFile, String yaml) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(yamlFile), "utf-8");){
            writer.write(yaml);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static int findUnusedLocalPort() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            return serverSocket.getLocalPort();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

