/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.shaded.com.addthis.metrics3.reporter.config;

import com.codahale.metrics.MetricRegistry;
import com.readytalk.metrics.StatsDReporter;
import java.util.ArrayList;
import java.util.List;
import net.nmoncho.shaded.com.addthis.metrics.reporter.config.AbstractStatsDReporterConfig;
import net.nmoncho.shaded.com.addthis.metrics.reporter.config.HostPort;
import net.nmoncho.shaded.com.addthis.metrics3.reporter.config.MetricFilterTransformer;
import net.nmoncho.shaded.com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDReporterConfig
extends AbstractStatsDReporterConfig
implements MetricsReporterConfigThree {
    private static final String REPORTER_CLASS = "com.readytalk.metrics.StatsDReporter";
    private static final Logger log = LoggerFactory.getLogger(StatsDReporterConfig.class);
    private List<StatsDReporter> reporters = new ArrayList<StatsDReporter>();

    @Override
    public boolean enable(MetricRegistry registry) {
        if (!this.setup(REPORTER_CLASS)) {
            return false;
        }
        boolean failures = false;
        for (HostPort hostPort : this.getFullHostList()) {
            try {
                log.info("Enabling StatsDReporter to {}:{}", new Object[]{hostPort.getHost(), hostPort.getPort()});
                StatsDReporter reporter = StatsDReporter.forRegistry((MetricRegistry)registry).convertRatesTo(this.getRealRateunit()).convertDurationsTo(this.getRealDurationunit()).prefixedWith(this.getResolvedPrefix()).filter(MetricFilterTransformer.generateFilter(this.getPredicate())).build(hostPort.getHost(), hostPort.getPort());
                reporter.start(this.getPeriod(), this.getRealTimeunit());
                this.reporters.add(reporter);
            }
            catch (Exception e) {
                log.error("Failed to enable StatsDReporter to {}:{}", (Object)new Object[]{hostPort.getHost(), hostPort.getPort()}, (Object)e);
                failures = true;
            }
        }
        return !failures;
    }

    @Override
    public void report() {
        for (StatsDReporter reporter : this.reporters) {
            reporter.report();
        }
    }

    void stopForTests() {
        for (StatsDReporter reporter : this.reporters) {
            reporter.stop();
        }
    }
}

