/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.shaded.com.addthis.metrics3.reporter.config;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.MetricsServlet;
import java.util.ArrayList;
import java.util.List;
import net.nmoncho.shaded.com.addthis.metrics.reporter.config.AbstractPrometheusReporterConfig;
import net.nmoncho.shaded.com.addthis.metrics.reporter.config.HostPort;
import net.nmoncho.shaded.com.addthis.metrics3.reporter.config.MetricFilterTransformer;
import net.nmoncho.shaded.com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import net.nmoncho.shaded.com.addthis.metrics3.reporter.config.PrometheusReporter;
import net.nmoncho.shaded.com.addthis.metrics3.reporter.config.prometheus.MetricRegistryDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporterConfig
extends AbstractPrometheusReporterConfig
implements MetricsReporterConfigThree {
    private static final Logger log = LoggerFactory.getLogger(PrometheusReporterConfig.class);
    private static final String SERVLET_CLASS = "io.prometheus.client.exporter.MetricsServlet";
    private static final String SENDER_CLASS = "io.prometheus.client.exporter.PushGateway";
    private final List<PrometheusReporter> reporters = new ArrayList<PrometheusReporter>();
    private MetricRegistry registry;

    public PrometheusReporterConfig() {
        this.setPeriod(60L);
    }

    @Override
    public boolean enable(MetricRegistry registry) {
        this.registry = registry;
        if (this.getType().equals((Object)AbstractPrometheusReporterConfig.Type.servlet)) {
            if (!this.isClassAvailable(SERVLET_CLASS)) {
                log.error("Tried to enable Prometheus Server Exporter, but class {} was not found", (Object)SERVLET_CLASS);
                return false;
            }
            return true;
        }
        if (!this.isClassAvailable(SENDER_CLASS)) {
            log.error("Tried to enable Prometheus Reporter, but class {} was not found", (Object)SENDER_CLASS);
            return false;
        }
        List<HostPort> hostPorts = this.getFullHostList();
        if (hostPorts == null || hostPorts.isEmpty()) {
            log.error("Prometheus pushgateway expects at least one host.");
            return false;
        }
        for (HostPort hostPort : hostPorts) {
            MetricFilter filter = MetricFilterTransformer.generateFilter(this.getPredicate());
            PrometheusReporter reporter = new PrometheusReporter(String.format("%s:%d", hostPort.getHost(), hostPort.getPort()), this.getJob(), this.getResolvedLabels(), registry, this.name, filter, this.getRealRateunit(), this.getRealDurationunit());
            reporter.start(this.getPeriod(), this.getRealTimeunit());
            this.reporters.add(reporter);
        }
        return true;
    }

    @Override
    public void report() {
        for (PrometheusReporter reporter : this.reporters) {
            reporter.report();
        }
    }

    @Override
    public List<HostPort> getFullHostList() {
        return this.getHostListAndStringList();
    }

    public MetricsServlet getMetricsServlet() {
        CollectorRegistry collectorRegistry = new CollectorRegistry();
        collectorRegistry.register((Collector)new MetricRegistryDecorator(this.registry, this.job, this.getResolvedLabels()));
        return new MetricsServlet(collectorRegistry);
    }
}

