/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.shaded.com.addthis.metrics.reporter.config;

import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import net.nmoncho.shaded.com.addthis.metrics.reporter.config.PredicateConfig;

public abstract class AbstractMetricReporterConfig {
    @NotNull
    @Min(value=1L)
    protected long period;
    @Pattern(regexp="^(DAYS|HOURS|MICROSECONDS|MILLISECONDS|MINUTES|NANOSECONDS|SECONDS)$", message="must be a valid java.util.concurrent.TimeUnit")
    protected String timeunit;
    @Pattern(regexp="^(DAYS|HOURS|MICROSECONDS|MILLISECONDS|MINUTES|NANOSECONDS|SECONDS)$", message="must be a valid java.util.concurrent.TimeUnit")
    protected String rateunit = "SECONDS";
    @Pattern(regexp="^(DAYS|HOURS|MICROSECONDS|MILLISECONDS|MINUTES|NANOSECONDS|SECONDS)$", message="must be a valid java.util.concurrent.TimeUnit")
    protected String durationunit = "MILLISECONDS";
    @Valid
    protected PredicateConfig predicate;

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public String getTimeunit() {
        return this.timeunit;
    }

    public void setTimeunit(String timeunit) {
        this.timeunit = timeunit;
    }

    public String getRateunit() {
        return this.rateunit;
    }

    public void setRateunit(String rateunit) {
        this.rateunit = rateunit;
    }

    public String getDurationunit() {
        return this.durationunit;
    }

    public void setDurationunit(String durationunit) {
        this.durationunit = durationunit;
    }

    public TimeUnit getRealTimeunit() {
        return TimeUnit.valueOf(this.timeunit);
    }

    public TimeUnit getRealRateunit() {
        return TimeUnit.valueOf(this.rateunit);
    }

    public TimeUnit getRealDurationunit() {
        return TimeUnit.valueOf(this.durationunit);
    }

    public PredicateConfig getPredicate() {
        return this.predicate;
    }

    public void setPredicate(PredicateConfig predicate) {
        this.predicate = predicate;
    }

    protected boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

