/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.cli;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import net.nmoncho.CQLDataLoader;
import net.nmoncho.dataset.cql.FileCQLDataSet;
import net.nmoncho.utils.EmbeddedCassandraServerHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CassandraUnitCommandLineStarter {
    private static final String LOCALHOST = "localhost";
    private static final CommandLineParser commandLineParser = new PosixParser();
    private static final Options options = new Options();
    private static final String CASSANDRA_YAML_TEMPLATE = "directory/samples/cassandra.yaml";
    private static final String CASSANDRA_YAML = "cassandra.yaml";
    private static CommandLine commandLine = null;

    public static void main(String[] args) {
        boolean exit = CassandraUnitCommandLineStarter.parseCommandLine(args);
        if (exit) {
            System.exit(1);
        } else {
            CassandraUnitCommandLineStarter.load();
        }
    }

    private static boolean parseCommandLine(String[] args) {
        CassandraUnitCommandLineStarter.initOptions();
        boolean exit = false;
        try {
            commandLine = commandLineParser.parse(options, args);
            if (commandLine.getOptions().length == 0) {
                exit = true;
                CassandraUnitCommandLineStarter.printUsage();
            } else if (CassandraUnitCommandLineStarter.containBadReplicationFactorArgumentValue()) {
                CassandraUnitCommandLineStarter.printUsage("Bad argument value for option r");
                exit = true;
            }
        }
        catch (ParseException e) {
            CassandraUnitCommandLineStarter.printUsage(e.getMessage());
            exit = true;
        }
        return exit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void load() {
        String tmpDir;
        String timeout;
        String installationFolder;
        String schemaOption;
        String port;
        block20: {
            System.out.println("Starting Cassandra...");
            port = commandLine.getOptionValue("p");
            schemaOption = commandLine.getOptionValue("s");
            installationFolder = commandLine.getOptionValue("d");
            timeout = commandLine.getOptionValue("t");
            tmpDir = String.valueOf(installationFolder) + "/temp";
            if (!CassandraUnitCommandLineStarter.hasValidValue(timeout)) {
                timeout = "20000";
            }
            Path cassandraYamlPath = Paths.get(CASSANDRA_YAML_TEMPLATE.replaceFirst("directory", installationFolder), new String[0]);
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try {
                    Stream<String> input = Files.lines(cassandraYamlPath);
                    try {
                        try (PrintWriter output = new PrintWriter(new File(installationFolder, CASSANDRA_YAML), "UTF-8");){
                            input.map(line -> line.replace("9042", port)).map(line -> line.replace("temp/", String.valueOf(tmpDir) + "/")).forEachOrdered(output::println);
                        }
                        if (input == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            String[] schemas;
            EmbeddedCassandraServerHelper.startEmbeddedCassandra(new File(installationFolder, CASSANDRA_YAML), tmpDir, Long.parseLong(timeout));
            if (!CassandraUnitCommandLineStarter.hasValidValue(schemaOption)) return;
            String[] stringArray = schemas = schemaOption.split(",");
            int n = schemas.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                String schema = stringArray[n2];
                CassandraUnitCommandLineStarter.dataSetLoad(LOCALHOST, port, schema);
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void dataSetLoad(String host, String port, String file) {
        CqlSession session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(host, Integer.parseInt(port)))).withLocalDatacenter("datacenter1")).build();
        CQLDataLoader dataLoader = new CQLDataLoader(session);
        dataLoader.load(new FileCQLDataSet(file));
        System.out.println("Loading completed");
    }

    private static boolean containBadReplicationFactorArgumentValue() {
        String replicationFactor = commandLine.getOptionValue("r");
        if (CassandraUnitCommandLineStarter.hasValidValue(replicationFactor)) {
            try {
                Integer.parseInt(replicationFactor);
                return false;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasValidValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private static void printUsage(String message) {
        System.out.println(message);
        CassandraUnitCommandLineStarter.printUsage();
    }

    private static void initOptions() {
        OptionBuilder.withLongOpt((String)"schema");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"schema to load");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"target port");
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"timeout");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"start up timeout");
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"installation directory");
        options.addOption(OptionBuilder.create((String)"d"));
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp("CassandraUnitStarter is a tool to start a cassandra instance", options);
    }
}

