/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.drama.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodUtils.class);
    private static final Map<Class<?>, Class<?>> BOXING_MAP = new HashMap();

    private MethodUtils() {
    }

    public static <T> Constructor<T> findMatchingConstructor(Class<T> clazz, Object ... params) {
        Constructor<?>[] constructors = clazz.getConstructors();
        LOGGER.trace("Selecting constructor");
        for (Constructor<?> constructor : constructors) {
            if (MethodUtils.parametersMatch(constructor.getParameterTypes(), params)) {
                return constructor;
            }
            LOGGER.trace("Constructor with parameters {} does not match", (Object)Arrays.toString(constructor.getParameterTypes()));
        }
        return null;
    }

    public static Method findMatchingMethod(Class<?> clazz, String methodName, Object ... params) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !MethodUtils.parametersMatch(method.getParameterTypes(), params)) continue;
            return method;
        }
        return null;
    }

    public static boolean parametersMatch(Class<?>[] parameterTypes, Object[] params) {
        if (parameterTypes == null && params == null) {
            return true;
        }
        if (parameterTypes == null || params == null) {
            return false;
        }
        if (parameterTypes.length != params.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (MethodUtils.isTypeCompatible(parameterTypes[i], params[i])) continue;
            return false;
        }
        return true;
    }

    private static Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        return BOXING_MAP.containsKey(primitiveType) ? BOXING_MAP.get(primitiveType) : null;
    }

    private static boolean isTypeCompatible(Class<?> parameterType, Object param) {
        return parameterType.isAssignableFrom(param.getClass()) || MethodUtils.isTypeCompatibleWithBoxing(parameterType, param.getClass());
    }

    private static boolean isTypeCompatibleWithBoxing(Class<?> targetClass, Class<?> parameterClass) {
        if (targetClass.isPrimitive() || parameterClass.isPrimitive()) {
            Class<?> convertedTarget = targetClass.isPrimitive() ? MethodUtils.getPrimitiveWrapper(targetClass) : targetClass;
            Class<?> convertedParameter = parameterClass.isPrimitive() ? MethodUtils.getPrimitiveWrapper(parameterClass) : parameterClass;
            return convertedTarget.isAssignableFrom(convertedParameter);
        }
        return false;
    }

    static {
        BOXING_MAP.put(Boolean.TYPE, Boolean.class);
        BOXING_MAP.put(Float.TYPE, Float.class);
        BOXING_MAP.put(Double.TYPE, Double.class);
        BOXING_MAP.put(Byte.TYPE, Byte.class);
        BOXING_MAP.put(Short.TYPE, Short.class);
        BOXING_MAP.put(Integer.TYPE, Integer.class);
        BOXING_MAP.put(Long.TYPE, Long.class);
        BOXING_MAP.put(Character.TYPE, Character.class);
    }
}

