/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.drama;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import net.ninjacat.drama.Actor;
import net.ninjacat.drama.ActorRef;
import net.ninjacat.drama.ActorSystemStopCallback;
import net.ninjacat.drama.FixedThreadPoolStrategy;
import net.ninjacat.drama.LocalActorRef;
import net.ninjacat.drama.Option;
import net.ninjacat.drama.ThreadingStrategy;
import net.ninjacat.drama.internal.ActorSystemInternal;
import net.ninjacat.drama.internal.SystemMessage;
import net.ninjacat.drama.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalActorSystem
implements ActorSystemInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalActorSystem.class);
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private final ExecutorService executors;
    private final Map<String, LocalActorRef> actors;
    private final Set<Actor> terminatingActors;
    private volatile boolean shuttingDown;
    private Option<ActorSystemStopCallback> stopCallback;

    LocalActorSystem() {
        this(new FixedThreadPoolStrategy());
    }

    LocalActorSystem(ThreadingStrategy threadingStrategy) {
        this.executors = threadingStrategy.getExecutorService();
        this.actors = new ConcurrentHashMap<String, LocalActorRef>();
        this.terminatingActors = Collections.synchronizedSet(new HashSet());
        this.shuttingDown = false;
        this.stopCallback = Option.absent();
    }

    @Override
    public void notifyActorReady(Actor actor) {
        LOGGER.debug("Actor {} become ready, checking inbox", (Object)actor.getName());
        this.executors.submit(actor);
    }

    @Override
    public void notifyActorTerminated(Actor actor) {
        this.terminatingActors.remove(actor);
        this.checkActorsAndNotifyStop();
    }

    @Override
    public Option<ActorRef> find(String name) {
        return Option.of((ActorRef)this.actors.get(name));
    }

    @Override
    public <T extends Actor> ActorRef createActor(Class<T> actorType) {
        return this.createActor(actorType, null);
    }

    @Override
    public <T extends Actor> ActorRef createActor(Class<T> actorType, String name) {
        return this.createActor(actorType, name, EMPTY_PARAMS);
    }

    @Override
    public <T extends Actor> ActorRef createActor(Class<T> actorType, String name, Object ... parameters) {
        Option<Constructor<T>> constructor = LocalActorSystem.getConstructor(actorType, parameters);
        if (constructor.isPresent()) {
            String actorName = LocalActorSystem.isEmpty(name) ? actorType.getSimpleName() + "-" + System.currentTimeMillis() : name;
            Option<Actor> actor = this.createActorInstance(constructor.get(), parameters);
            if (actor.isPresent()) {
                return this.createAndRegisterActorRef(actor.get(), actorName);
            }
            LOGGER.error("Failed to create instance of actor {}", (Object)actorName);
            throw new IllegalStateException(String.format("Failed to create instance of actor of type %s", actorType));
        }
        LOGGER.error("No valid constructor found for actor of type {}", (Object)actorType.getCanonicalName());
        throw new IllegalStateException(String.format("Cannot create actor of type %s", actorType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWithCallback(ActorSystemStopCallback callback) {
        LocalActorSystem localActorSystem = this;
        synchronized (localActorSystem) {
            this.stopCallback = Option.of(callback);
        }
        this.stop();
    }

    @Override
    public void stop() {
        this.shuttingDown = true;
        this.deleteActors();
    }

    protected void postMessageToActor(Actor actor, Object message, ActorRef sender) {
        if (this.terminatingActors.contains(actor)) {
            LOGGER.debug("Actor {} is in terminating state, ignoring message", (Object)actor.getName());
            return;
        }
        LOGGER.debug("Posting message to actor {}", (Object)actor.getName());
        actor.putMessageToInbox(sender, message);
        if (actor.isReady()) {
            this.executors.submit(actor);
        } else {
            LOGGER.debug("Actor {} is busy, postponing message retrieval", (Object)actor.getName());
        }
    }

    protected void deleteActor(Actor ref) {
        this.postMessageToActor(ref, (Object)SystemMessage.TERMINATE, null);
        this.terminatingActors.add(ref);
        this.actors.remove(ref.getName());
    }

    Option<Actor> createActorInstance(Constructor<?> constructor, Object ... parameters) {
        try {
            return Option.of((Actor)(parameters.length == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(parameters)));
        }
        catch (Exception ignored) {
            return Option.absent();
        }
    }

    private static boolean isEmpty(String name) {
        return name == null || name.length() == 0;
    }

    private static <T> Option<Constructor<T>> getConstructor(Class<T> actorType, Object ... parameters) {
        return Option.of(MethodUtils.findMatchingConstructor(actorType, parameters));
    }

    private synchronized void checkActorsAndNotifyStop() {
        if (this.isNoActorsLeft() && this.shuttingDown) {
            this.executors.shutdown();
            if (this.stopCallback.isPresent()) {
                this.stopCallback.get().onStopped();
            }
        }
    }

    private boolean isNoActorsLeft() {
        return this.terminatingActors.isEmpty() && this.actors.isEmpty();
    }

    private void deleteActors() {
        this.checkActorsAndNotifyStop();
        for (Map.Entry<String, LocalActorRef> actorEntry : this.actors.entrySet()) {
            this.deleteActor(actorEntry.getValue().getWrappedActor());
        }
        this.actors.clear();
    }

    private ActorRef createAndRegisterActorRef(Actor actor, String actorName) {
        LocalActorRef actorRef = this.wrapActor(actor);
        actor.initActorSystem(actorName, actorRef, this);
        this.actors.put(actor.getName(), actorRef);
        this.postMessageToActor(actor, (Object)SystemMessage.START, null);
        return actorRef;
    }

    private LocalActorRef wrapActor(Actor actor) {
        return new LocalActorRef(this, actor);
    }
}

