/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.drama;

import net.ninjacat.drama.Actor;
import net.ninjacat.drama.ActorRef;
import net.ninjacat.drama.LocalActorSystem;

class LocalActorRef
implements ActorRef {
    private final LocalActorSystem actorSystem;
    private final Actor ref;

    LocalActorRef(LocalActorSystem actorSystem, Actor ref) {
        this.actorSystem = actorSystem;
        this.ref = ref;
    }

    public void tell(Object message, ActorRef sender) {
        this.actorSystem.postMessageToActor(this.ref, message, sender);
    }

    public void tell(Object message) {
        this.actorSystem.postMessageToActor(this.ref, message, null);
    }

    public void stop() {
        this.actorSystem.deleteActor(this.ref);
    }

    public String getName() {
        return this.ref.getName();
    }

    public Actor getWrappedActor() {
        return this.ref;
    }

    public String toString() {
        return "LocalActorRef{ref=" + this.ref + '}';
    }
}

