/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.drama;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ninjacat.drama.ActorRef;
import net.ninjacat.drama.MessageWrapper;
import net.ninjacat.drama.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseActor {
    private static final String SIGNATURE_MISMATCH = "Method %s is annotated with @Receiver, but its signature is wrong. Should be void method(ActorRef, MessageType)";
    private static final String DUPLICATE_RECEIVER = "Cannot register method %s for %s, method %s is already registered for this message type";
    protected final Collection<Method> allReceiverMethods;
    protected final Map<Class<?>, Method> receivers;
    protected final Set<Class<?>> unsupportedMessageClasses = new HashSet();

    BaseActor() {
        this.receivers = new HashMap();
        this.allReceiverMethods = new ArrayList<Method>();
        this.gatherReceivers();
    }

    protected void unhandled(ActorRef sender, Object message) {
    }

    Method findReceiverMethod(Class<?> messageClass) {
        Method receiver = null;
        if (this.receivers.containsKey(messageClass)) {
            receiver = this.receivers.get(messageClass);
        } else if (!this.unsupportedMessageClasses.contains(messageClass) && (receiver = this.findMethodForDescendantMessageType(messageClass)) == null) {
            this.unsupportedMessageClasses.add(messageClass);
        }
        return receiver;
    }

    void dispatchMessage(MessageWrapper message) {
        Class<?> messageClass = message.getMessage().getClass();
        Method receiver = this.findReceiverMethod(messageClass);
        if (receiver == null) {
            this.callUnhandledIgnoringFailures(message);
        } else {
            this.callReceiverIgnoringFailures(message, receiver);
        }
    }

    private static Class<?> getDeclaredMessageType(Method method) {
        return method.getParameterTypes()[1];
    }

    private static boolean isSignatureMatchesReceiver(Method method) {
        return method.getParameterTypes().length == 2 && method.getParameterTypes()[0].equals(ActorRef.class);
    }

    private void gatherReceivers() {
        for (Method method : this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Receiver.class)) continue;
            this.addMatchingMethod(method);
        }
    }

    private Method findMethodForDescendantMessageType(Class<?> messageActualType) {
        for (Method method : this.allReceiverMethods) {
            Class<?> messageDeclaredType = BaseActor.getDeclaredMessageType(method);
            if (!messageDeclaredType.isAssignableFrom(messageActualType)) continue;
            this.cacheMethodByMessageType(method, messageActualType);
            return method;
        }
        return null;
    }

    private void cacheMethodByMessageType(Method method, Class<?> messageDeclaredType) {
        if (this.receivers.containsKey(messageDeclaredType)) {
            throw new IllegalStateException(String.format(DUPLICATE_RECEIVER, method.getName(), messageDeclaredType.getCanonicalName(), this.receivers.get(messageDeclaredType).getName()));
        }
        this.receivers.put(messageDeclaredType, method);
    }

    private void addMatchingMethod(Method method) {
        if (!BaseActor.isSignatureMatchesReceiver(method)) {
            throw new IllegalStateException(String.format(SIGNATURE_MISMATCH, method.getName()));
        }
        this.cacheMethodByMessageType(method, BaseActor.getDeclaredMessageType(method));
        this.allReceiverMethods.add(method);
    }

    private void callReceiverIgnoringFailures(MessageWrapper message, Method receiver) {
        try {
            receiver.invoke((Object)this, message.getSender(), message.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callUnhandledIgnoringFailures(MessageWrapper message) {
        try {
            this.unhandled(message.getSender(), message.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

