/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.drama;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import net.ninjacat.drama.ActorRef;
import net.ninjacat.drama.ActorSystem;
import net.ninjacat.drama.BaseActor;
import net.ninjacat.drama.LocalActorRef;
import net.ninjacat.drama.MessageWrapper;
import net.ninjacat.drama.Receiver;
import net.ninjacat.drama.internal.ActorSystemInternal;
import net.ninjacat.drama.internal.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Actor
extends BaseActor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Actor.class);
    private final Queue<MessageWrapper> inbox = new ConcurrentLinkedQueue<MessageWrapper>();
    private final Semaphore executionLock = new Semaphore(1);
    private LocalActorRef self;
    private String name;
    private ActorSystemInternal system;
    private volatile boolean terminated = false;

    public String getName() {
        return this.name;
    }

    public ActorRef getSelf() {
        return this.self;
    }

    public ActorSystem getActorSystem() {
        return this.system;
    }

    public final void run() {
        this.lockAndDispatchMessage();
        this.notifyReadiness();
    }

    @Receiver
    public final void onSystemMessage(ActorRef sender, SystemMessage message) {
        switch (message) {
            case START: {
                LOGGER.debug("Received START message");
                this.onStartup();
                break;
            }
            case TERMINATE: {
                LOGGER.debug("Received TERMINATE message");
                this.performActorShutdown();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Actor actor = (Actor)o;
        if (!this.name.equals(actor.name)) {
            return false;
        }
        return this.system.equals(actor.system);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.system.hashCode();
        return result;
    }

    public String toString() {
        return "Actor{name='" + this.name + '\'' + '}';
    }

    protected Semaphore getExecutionLock() {
        return this.executionLock;
    }

    protected void onStartup() {
    }

    protected void onShutdown() {
    }

    boolean isReady() {
        return this.getExecutionLock().availablePermits() == 1;
    }

    void initActorSystem(String actorName, LocalActorRef actorRef, ActorSystemInternal systemRef) {
        this.name = actorName;
        this.self = actorRef;
        this.system = systemRef;
    }

    ActorSystemInternal getSystemRef() {
        return this.system;
    }

    MessageWrapper retrieveMessage() {
        return this.inbox.poll();
    }

    void putMessageToInbox(ActorRef sender, Object message) {
        if (!this.terminated) {
            this.inbox.add(new MessageWrapper(sender, message));
        }
    }

    boolean tryAquireLock() {
        return this.executionLock.tryAcquire();
    }

    boolean isThereMoreMessages() {
        return !this.inbox.isEmpty();
    }

    void releaseLock() {
        this.executionLock.release();
    }

    void notifyReadiness() {
        if (this.isThereMoreMessages()) {
            this.getSystemRef().notifyActorReady(this);
        }
    }

    private void performActorShutdown() {
        this.terminated = true;
        this.inbox.clear();
        this.onShutdown();
        this.getSystemRef().notifyActorTerminated(this);
    }

    private void lockAndDispatchMessage() {
        if (this.tryAquireLock()) {
            MessageWrapper message = this.retrieveMessage();
            if (message != null) {
                this.dispatchMessage(message);
            }
            this.releaseLock();
        }
    }
}

