package net.ninjacat.drama;

class LocalActorRef implements ActorRef {
    private final LocalActorSystem actorSystem;
    private final Actor ref;

    LocalActorRef(LocalActorSystem actorSystem, Actor ref) {
        this.actorSystem = actorSystem;
        this.ref = ref;
    }

    @Override
    public void tell(Object message, ActorRef sender) {
        actorSystem.postMessageToActor(ref, message, sender);
    }

    @Override
    public void tell(Object message) {
        actorSystem.postMessageToActor(ref, message, null);
    }

    @Override
    public void stop() {
        actorSystem.deleteActor(ref);
    }

    @Override
    public String getName() {
        return ref.getName();
    }

    public Actor getWrappedActor() {
        return ref;
    }

    @Override
    public String toString() {
        return "LocalActorRef{" +
                "ref=" + ref +
                '}';
    }
}
