package net.ninjacat.drama;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * * {@link ActorSystem} threading strategy that uses fixed thread pool {@link java.util.concurrent.ExecutorService} with
 * number of threads equal to number of available CPU cores.
 */
public final class FixedThreadPoolStrategy implements ThreadingStrategy {
    @Override
    public ExecutorService getExecutorService() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }
}
