package net.ninjacat.drama;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * {@link ActorSystem} threading strategy that uses cached thread pool {@link java.util.concurrent.ExecutorService}
 */
public final class CachedThreadPoolStrategy implements ThreadingStrategy {

    @Override
    public ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool();
    }
}
