package net.ninjacat.drama;

/**
 * Factory class for {@link net.ninjacat.drama.ActorSystem}
 */
public class ActorSystemFactory {

    private ThreadingStrategy threadingStrategy;

    /**
     * Sets {@link net.ninjacat.drama.ThreadingStrategy} for new instances of {@link net.ninjacat.drama.ActorSystem}s
     * created by this factory
     *
     * @param threadingStrategy instance of ThreadingStrategy
     * @return factory itself
     */
    public ActorSystemFactory setThreadingStrategy(ThreadingStrategy threadingStrategy) {
        this.threadingStrategy = threadingStrategy;
        return this;
    }

    /**
     * Creates a new ActorSystem.
     *
     * @return appropriately configured instance of {@link net.ninjacat.drama.ActorSystem}
     */
    public ActorSystem create() {
        return new LocalActorSystem(threadingStrategy);
    }
}
