package net.ninjacat.drama;

public interface ActorRef {
    /**
     * Send a message to an actor represented by this reference
     *
     * @param message message instance
     * @param sender  reference to a sending actor
     */
    void tell(Object message, ActorRef sender);

    /**
     * Send a message to an actor represented by this reference. Receiver method will see sender as {@code null}
     *
     * @param message message instance
     */
    void tell(Object message);

    /**
     * Stops actor. No new messages will be received by the actor after this method is called.
     */
    void stop();

    /**
     * @return The name of the actor in its parent {@link net.ninjacat.drama.ActorSystem}
     */
    String getName();
}
