/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class XmlSummaryFileTarget
implements ExecutionTarget {
    public static final int XML_INDENTATION_SIZE = 2;
    protected String encoding;
    protected Map<ChecksumFile, Map<String, String>> filesHashcodes;
    protected File summaryFile;
    protected final Iterable<? extends ArtifactListener> artifactListeners;

    public XmlSummaryFileTarget(File summaryFile, String encoding, Iterable<? extends ArtifactListener> artifactListeners) {
        this.summaryFile = summaryFile;
        this.encoding = encoding;
        this.artifactListeners = artifactListeners;
    }

    @Override
    public void init() {
        this.filesHashcodes = new HashMap<ChecksumFile, Map<String, String>>();
    }

    @Override
    public void write(String digest, ChecksumFile file, String algorithm) {
        if (!this.filesHashcodes.containsKey(file)) {
            this.filesHashcodes.put(file, new HashMap());
        }
        Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
        fileHashcodes.put(algorithm, digest);
    }

    @Override
    public void close(final String subPath) throws ExecutionTargetCloseException {
        FileUtils.mkdir((String)this.summaryFile.getParent());
        OutputStreamWriter outputStream = null;
        try {
            outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.summaryFile), this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
        Map.Entry[] entries = this.filesHashcodes.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entries, new Comparator<Map.Entry<ChecksumFile, Map<String, String>>>(){

            @Override
            public int compare(Map.Entry<ChecksumFile, Map<String, String>> o1, Map.Entry<ChecksumFile, Map<String, String>> o2) {
                ChecksumFile f1 = o1.getKey();
                ChecksumFile f2 = o2.getKey();
                return f1.getRelativePath(f1, subPath).compareTo(f2.getRelativePath(f2, subPath));
            }
        });
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)outputStream, StringUtils.repeat((String)" ", (int)2));
        xmlWriter.startElement("files");
        for (Map.Entry entry : entries) {
            ChecksumFile file = (ChecksumFile)entry.getKey();
            xmlWriter.startElement("file");
            xmlWriter.addAttribute("name", file.getRelativePath(file, subPath));
            Map fileHashcodes = (Map)entry.getValue();
            for (String algorithm : fileHashcodes.keySet()) {
                xmlWriter.startElement("hashcode");
                xmlWriter.addAttribute("algorithm", algorithm);
                xmlWriter.writeText((String)fileHashcodes.get(algorithm));
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        try {
            ((Writer)outputStream).close();
            for (ArtifactListener artifactListener : this.artifactListeners) {
                artifactListener.artifactCreated(this.summaryFile, "xml");
            }
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
    }
}

