/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution;

import java.security.NoSuchAlgorithmException;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterException;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterFactory;
import net.nicoulaj.maven.plugins.checksum.digest.FileDigester;
import net.nicoulaj.maven.plugins.checksum.execution.AbstractExecution;
import net.nicoulaj.maven.plugins.checksum.execution.ExecutionException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetInitializationException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetWriteException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;

public class FailOnErrorExecution
extends AbstractExecution {
    @Override
    public void run() throws ExecutionException {
        this.checkParameters();
        for (ExecutionTarget target : this.getTargets()) {
            try {
                target.init();
            }
            catch (ExecutionTargetInitializationException e) {
                throw new ExecutionException(e.getMessage());
            }
        }
        for (ChecksumFile file : this.files) {
            for (String algorithm : this.getAlgorithms()) {
                try {
                    FileDigester digester = DigesterFactory.getInstance().getFileDigester(algorithm);
                    String hash = digester.calculate(file.getFile());
                    for (ExecutionTarget target : this.getTargets()) {
                        try {
                            target.write(hash, file, algorithm);
                        }
                        catch (ExecutionTargetWriteException e) {
                            throw new ExecutionException(e.getMessage());
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ExecutionException("Unsupported algorithm " + algorithm + ".");
                }
                catch (DigesterException e) {
                    throw new ExecutionException("Unable to calculate " + algorithm + " hash for " + file.getFile().getName() + ": " + e.getMessage());
                }
            }
        }
        for (ExecutionTarget target : this.getTargets()) {
            try {
                target.close(this.subPath);
            }
            catch (ExecutionTargetCloseException e) {
                throw new ExecutionException(e.getMessage());
            }
        }
    }
}

