/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.trainingwheels.base.file;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class PathFile
extends File {
    private PathFile(String path) {
        super(path);
    }

    public FileSystem getFileSystem() {
        return this.toPath().getFileSystem();
    }

    @Override
    public Path toPath() {
        throw new IllegalArgumentException("toPath must be implemented!");
    }

    @Override
    public String getName() {
        return this.toPath().getFileName().toString();
    }

    @Override
    public boolean isFile() {
        return Files.isRegularFile(this.toPath(), new LinkOption[0]);
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.toPath(), new LinkOption[0]);
    }

    public static PathFile newInstance(Path path) {
        PathFile file = (PathFile)Mockito.mock(PathFile.class, (Answer)Answers.CALLS_REAL_METHODS);
        ((PathFile)Mockito.doReturn((Object)path).when((Object)file)).toPath();
        return file;
    }
}

