/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.jst.api.FileSource;
import net.neoforged.jst.cli.PathType;
import net.neoforged.jst.cli.io.ArchiveFileSource;
import net.neoforged.jst.cli.io.FolderFileSource;
import net.neoforged.jst.cli.io.SingleFileSource;

public final class FileSources {
    private FileSources() {
    }

    public static FileSource create(Path path, PathType format) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("File does not exist: " + String.valueOf(path));
        }
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case PathType.AUTO -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    FolderFileSource var2_2;
                    yield var2_2 = new FolderFileSource(path);
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        ArchiveFileSource var2_3 = new ArchiveFileSource(path);
                        yield var2_3;
                    }
                    catch (IOException ignored) {
                        SingleFileSource var2_4 = new SingleFileSource(path);
                        yield var2_4;
                    }
                }
                throw new IOException("Cannot detect type of " + String.valueOf(path) + " it is neither file nor folder.");
            }
            case PathType.FILE -> {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    throw new IOException("Expected " + String.valueOf(path) + " to be a file.");
                }
                SingleFileSource var2_5 = new SingleFileSource(path);
                yield var2_5;
            }
            case PathType.ARCHIVE -> {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    throw new IOException("Expected " + String.valueOf(path) + " to be a file.");
                }
                ArchiveFileSource var2_6 = new ArchiveFileSource(path);
                yield var2_6;
            }
            case PathType.FOLDER -> {
                FolderFileSource var2_7;
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    throw new IOException("Expected " + String.valueOf(path) + " to be a directory.");
                }
                yield var2_7 = new FolderFileSource(path);
            }
        };
    }
}

