/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.neoforged.jst.api.FileEntry;
import net.neoforged.jst.api.FileSink;
import net.neoforged.jst.api.FileSource;
import net.neoforged.jst.api.IntelliJEnvironment;
import net.neoforged.jst.api.Logger;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.TransformContext;
import net.neoforged.jst.cli.OrderedParallelWorkQueue;
import net.neoforged.jst.cli.intellij.ClasspathSetup;
import net.neoforged.jst.cli.intellij.IntelliJEnvironmentImpl;

class SourceFileProcessor
implements AutoCloseable {
    private final IntelliJEnvironmentImpl ijEnv;
    private int maxQueueDepth = 50;
    private final Logger logger;
    private final List<String> ignoredPrefixes = new ArrayList<String>();

    public SourceFileProcessor(Logger logger) throws IOException {
        this.logger = logger;
        this.ijEnv = new IntelliJEnvironmentImpl(logger);
        this.ijEnv.addCurrentJdkToClassPath();
    }

    public boolean process(FileSource source, FileSink sink, List<SourceTransformer> transformers) throws IOException {
        if (source.canHaveMultipleEntries() && !sink.canHaveMultipleEntries()) {
            throw new IllegalStateException("Cannot have an input with possibly more than one file when the output is a single file.");
        }
        TransformContext context = new TransformContext((IntelliJEnvironment)this.ijEnv, source, sink, this.logger);
        VirtualFile sourceRoot = source.createSourceRoot(VirtualFileManager.getInstance());
        this.ijEnv.addSourceRoot(sourceRoot);
        for (SourceTransformer transformer : transformers) {
            transformer.beforeRun(context);
        }
        if (source.isOrdered() && sink.isOrdered()) {
            try (Stream stream = source.streamEntries();){
                stream.forEach(entry -> {
                    try {
                        this.processEntry((FileEntry)entry, sourceRoot, transformers, sink);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        AtomicBoolean success = new AtomicBoolean(true);
        try (OrderedParallelWorkQueue asyncOut = new OrderedParallelWorkQueue(sink, this.maxQueueDepth);
             Stream stream = source.streamEntries();){
            stream.forEach(entry -> asyncOut.submitAsync(parallelSink -> {
                try {
                    if (!this.processEntry((FileEntry)entry, sourceRoot, transformers, (FileSink)parallelSink)) {
                        success.set(false);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }));
        }
        if (!success.get()) {
            return false;
        }
        boolean isOk = true;
        for (SourceTransformer transformer : transformers) {
            isOk = isOk && transformer.afterRun(context);
        }
        return isOk;
    }

    private boolean processEntry(FileEntry entry, VirtualFile sourceRoot, List<SourceTransformer> transformers, FileSink sink) throws IOException {
        if (entry.directory()) {
            sink.putDirectory(entry.relativePath());
            return true;
        }
        boolean[] success = new boolean[]{true};
        try (InputStream in = entry.openInputStream();){
            byte[] content = in.readAllBytes();
            FileTime lastModified = entry.lastModified();
            if (!this.isIgnored(entry.relativePath()) && !transformers.isEmpty() && entry.hasExtension("java")) {
                byte[] orgContent = content;
                content = this.transformSource(sourceRoot, entry, transformers, content, success);
                if (!success[0]) {
                    boolean bl = false;
                    return bl;
                }
                if (orgContent != content) {
                    lastModified = FileTime.from(Instant.now());
                }
            }
            sink.putFile(entry.relativePath(), lastModified, content);
        }
        return true;
    }

    private boolean isIgnored(String relativePath) {
        for (String ignoredPrefix : this.ignoredPrefixes) {
            if (!relativePath.startsWith(ignoredPrefix)) continue;
            return true;
        }
        return false;
    }

    private byte[] transformSource(VirtualFile contentRoot, FileEntry entry, List<SourceTransformer> transformers, byte[] originalContentBytes, boolean[] successOut) {
        String path = entry.relativePath();
        VirtualFile sourceFile = contentRoot.findFileByRelativePath(path);
        if (sourceFile == null) {
            System.err.println("Can't transform " + path + " since IntelliJ doesn't see it in the source jar.");
            return originalContentBytes;
        }
        PsiFile psiFile = this.ijEnv.getPsiManager().findFile(sourceFile);
        if (psiFile == null) {
            System.err.println("Can't transform " + path + " since IntelliJ can't load it.");
            return originalContentBytes;
        }
        ArrayList replacementsList = new ArrayList();
        Replacements replacements = new Replacements(replacementsList);
        for (SourceTransformer transformer : transformers) {
            transformer.visitFile(psiFile, replacements);
        }
        List readOnlyReplacements = Collections.unmodifiableList(replacementsList);
        boolean success = true;
        for (SourceTransformer transformer : transformers) {
            success = success && transformer.beforeReplacement(entry, readOnlyReplacements);
        }
        successOut[0] = success;
        if (!success || replacements.isEmpty()) {
            return originalContentBytes;
        }
        CharSequence originalContent = psiFile.getViewProvider().getContents();
        return replacements.apply(originalContent).getBytes(StandardCharsets.UTF_8);
    }

    public void setMaxQueueDepth(int maxQueueDepth) {
        this.maxQueueDepth = maxQueueDepth;
    }

    public void addLibrariesList(Path librariesList) throws IOException {
        ClasspathSetup.addLibraries(this.logger, librariesList, this.ijEnv);
    }

    public void addLibrary(Path library) {
        ClasspathSetup.addLibrary(this.logger, library, this.ijEnv);
    }

    public void addIgnoredPrefix(String ignoredPrefix) {
        System.out.println("Not transforming entries starting with " + ignoredPrefix);
        this.ignoredPrefixes.add(ignoredPrefix);
    }

    @Override
    public void close() throws IOException {
        this.ijEnv.close();
    }
}

