/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.api;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.jst.api.PostProcessReplacer;
import net.neoforged.jst.api.Replacements;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ImportHelper
implements PostProcessReplacer {
    private final PsiJavaFile psiFile;
    private final Map<String, String> importedNames = new HashMap<String, String>();
    private final Set<String> successfulImports = new HashSet<String>();

    public ImportHelper(PsiJavaFile psiFile) {
        PsiElement resolved;
        this.psiFile = psiFile;
        if (psiFile.getPackageStatement() != null && (resolved = psiFile.getPackageStatement().getPackageReference().resolve()) instanceof PsiPackage) {
            PsiPackage pkg = (PsiPackage)resolved;
            for (PsiClass cls : pkg.getClasses()) {
                this.importedNames.put(cls.getName(), cls.getQualifiedName());
            }
        }
        if (psiFile.getImportList() != null) {
            for (PsiImportStatement psiImportStatement : psiFile.getImportList().getImportStatements()) {
                PsiElement res = psiImportStatement.resolve();
                if (res instanceof PsiPackage) {
                    PsiPackage pkg = (PsiPackage)res;
                    for (PsiClass cls : pkg.getClasses()) {
                        this.importedNames.put(cls.getName(), cls.getQualifiedName());
                    }
                    continue;
                }
                if (!(res instanceof PsiClass)) continue;
                PsiClass cls = (PsiClass)res;
                this.importedNames.put(cls.getName(), cls.getQualifiedName());
            }
            for (PsiImportStatement psiImportStatement : psiFile.getImportList().getImportStaticStatements()) {
                PsiElement res = psiImportStatement.resolve();
                if (res instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)res;
                    this.importedNames.put(method.getName(), method.getName());
                    continue;
                }
                if (res instanceof PsiField) {
                    PsiField fld = (PsiField)res;
                    this.importedNames.put(fld.getName(), fld.getName());
                    continue;
                }
                if (!(res instanceof PsiClass)) continue;
                PsiClass cls = (PsiClass)res;
                if (!psiImportStatement.isOnDemand()) continue;
                for (PsiMethod psiMethod : cls.getAllMethods()) {
                    if (!psiMethod.getModifierList().hasModifierProperty("static")) continue;
                    this.importedNames.put(psiMethod.getName(), psiMethod.getName());
                }
                for (PsiMethod psiMethod : cls.getAllFields()) {
                    if (psiMethod.getModifierList() == null || !psiMethod.getModifierList().hasModifierProperty("static")) continue;
                    this.importedNames.put(psiMethod.getName(), psiMethod.getName());
                }
                for (PsiMethod psiMethod : cls.getAllInnerClasses()) {
                    this.importedNames.put(psiMethod.getName(), psiMethod.getQualifiedName());
                }
            }
        }
    }

    @VisibleForTesting
    public boolean canImport(String name) {
        return !this.importedNames.containsKey(name);
    }

    public String importClass(String cls) {
        String[] clsByDot = cls.split("\\.");
        if (clsByDot.length == 1 || this.successfulImports.contains(cls)) {
            return clsByDot[clsByDot.length - 1];
        }
        if (clsByDot.length == 3 && clsByDot[0].equals("java") && clsByDot[1].equals("lang")) {
            return clsByDot[2];
        }
        String name = clsByDot[clsByDot.length - 1];
        if (Objects.equals(this.importedNames.get(name), cls)) {
            return name;
        }
        if (this.canImport(name)) {
            this.successfulImports.add(cls);
            return name;
        }
        return cls;
    }

    @Override
    public void process(Replacements replacements) {
        if (this.successfulImports.isEmpty()) {
            return;
        }
        String insertion = this.successfulImports.stream().sorted().map(s -> "import " + s + ";").collect(Collectors.joining("\n"));
        if (this.psiFile.getImportList() != null && this.psiFile.getImportList().getLastChild() != null) {
            PsiElement lastImport = this.psiFile.getImportList().getLastChild();
            replacements.insertAfter(lastImport, "\n\n" + insertion);
        } else {
            replacements.insertBefore((PsiElement)this.psiFile.getClasses()[0], insertion + "\n\n");
        }
    }

    @Nullable
    public static ImportHelper get(PsiFile file) {
        ImportHelper importHelper;
        if (file instanceof PsiJavaFile) {
            PsiJavaFile j = (PsiJavaFile)file;
            importHelper = ImportHelper.get(j);
        } else {
            importHelper = null;
        }
        return importHelper;
    }

    public static ImportHelper get(PsiJavaFile file) {
        return PostProcessReplacer.getOrCreateReplacer((PsiFile)file, ImportHelper.class, k -> new ImportHelper(file));
    }
}

