/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.api;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.jst.api.FileEntry;

class ZipFileEntry
implements FileEntry {
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;

    public ZipFileEntry(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    @Override
    public boolean directory() {
        return this.zipEntry.isDirectory();
    }

    @Override
    public String relativePath() {
        return this.zipEntry.getName();
    }

    @Override
    public FileTime lastModified() {
        return this.zipEntry.getLastModifiedTime();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.zipFile.getInputStream(this.zipEntry);
    }
}

