/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.api;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.neoforged.jst.api.Replacements;
import org.jetbrains.annotations.UnmodifiableView;

public interface PostProcessReplacer {
    public static final Key<Map<Class<?>, PostProcessReplacer>> REPLACERS = Key.create((String)"jst.post_process_replacers");

    public void process(Replacements var1);

    public static @UnmodifiableView Map<Class<?>, PostProcessReplacer> getReplacers(PsiFile file) {
        Map rep = (Map)file.getUserData(REPLACERS);
        return rep == null ? Map.of() : Collections.unmodifiableMap(rep);
    }

    public static <T extends PostProcessReplacer> T getOrCreateReplacer(PsiFile file, Class<T> type, Function<PsiFile, T> creator) {
        IdentityHashMap<Class, PostProcessReplacer> rep = (IdentityHashMap<Class, PostProcessReplacer>)file.getUserData(REPLACERS);
        if (rep == null) {
            rep = new IdentityHashMap<Class, PostProcessReplacer>();
            file.putUserData(REPLACERS, rep);
        }
        return (T)rep.computeIfAbsent(type, k -> (PostProcessReplacer)creator.apply(file));
    }
}

