/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.api;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.jst.api.Replacement;

public final class Replacements {
    private final List<Replacement> replacements = new ArrayList<Replacement>();

    public boolean isEmpty() {
        return this.replacements.isEmpty();
    }

    public void replace(PsiElement element, String newText) {
        this.add(new Replacement(element.getTextRange(), newText));
    }

    public void remove(PsiElement element) {
        int pos = element.getTextRange().getEndOffset();
        if (element.getContainingFile().getText().charAt(pos) == ' ') {
            this.add(new Replacement(new TextRange(element.getTextRange().getStartOffset(), pos + 1), ""));
        } else {
            this.replace(element, "");
        }
    }

    public void insertBefore(PsiElement element, String newText) {
        int startOffset = element.getTextRange().getStartOffset();
        this.add(new Replacement(new TextRange(startOffset, startOffset), newText));
    }

    public void insertAfter(PsiElement element, String newText) {
        int endOffset = element.getTextRange().getEndOffset();
        this.add(new Replacement(new TextRange(endOffset, endOffset), newText));
    }

    public void add(Replacement replacement) {
        this.replacements.add(replacement);
    }

    public String apply(CharSequence originalContent) {
        this.replacements.sort(Replacement.COMPARATOR);
        StringBuilder writer = new StringBuilder();
        writer.append(originalContent, 0, this.replacements.get(0).range().getStartOffset());
        for (int i = 0; i < this.replacements.size(); ++i) {
            Replacement replacement = this.replacements.get(i);
            TextRange range = replacement.range();
            if (i > 0) {
                Replacement previousReplacement = this.replacements.get(i - 1);
                if (previousReplacement.range().getEndOffset() > range.getStartOffset()) {
                    throw new IllegalStateException("Trying to replace overlapping ranges: " + replacement + " and " + previousReplacement);
                }
                writer.append(originalContent, previousReplacement.range().getEndOffset(), range.getStartOffset());
            }
            writer.append(replacement.newText());
        }
        writer.append(originalContent, this.replacements.get(this.replacements.size() - 1).range().getEndOffset(), originalContent.length());
        return writer.toString();
    }
}

