/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.neoforged.javadoctor.injector.FixedOrderComparator;
import net.neoforged.javadoctor.spec.JavadocEntry;
import org.jetbrains.annotations.Nullable;

public class DocFormatter {
    public static final int MAX_PARAM_LENGTH = 80;
    public static final Comparator<String> TAGS_ORDER = FixedOrderComparator.of("author", "version", "param", "return", "throws", "exception", "see", "since", "serial", "deprecated");

    public static WithLength formatDoc(String indent, JavadocEntry entry, @Nullable List<String> parameters, @Nullable List<String> genericTypes) {
        String[] linesSplit = entry.doc() == null ? new String[]{} : entry.doc().split("\n");
        ArrayList<String> lines = new ArrayList<String>(linesSplit.length);
        for (String line : linesSplit) {
            lines.add(line);
        }
        Map tags = entry.tags() instanceof HashMap ? entry.tags() : new HashMap(entry.tags() == null ? new HashMap() : entry.tags());
        DocFormatter.appendJust(lines, tags, "author", "version");
        if (entry.parameters() != null && entry.parameters().length != 0) {
            Objects.requireNonNull(parameters);
            DocFormatter.appendParameters(lines, entry.parameters(), parameters::get);
        }
        if (entry.typeParameters() != null && entry.typeParameters().length != 0) {
            Objects.requireNonNull(genericTypes);
            DocFormatter.appendParameters(lines, entry.typeParameters(), i -> "<" + (String)genericTypes.get(i) + ">");
        }
        tags.entrySet().stream().sorted(Map.Entry.comparingByKey(TAGS_ORDER)).flatMap(e -> ((List)e.getValue()).stream().sorted(Comparator.naturalOrder()).flatMap(v -> DocFormatter.formatTag((String)e.getKey(), v).stream())).forEach(lines::add);
        String joined = lines.stream().map(ln -> indent + " * " + ln).collect(Collectors.joining("\n"));
        return new WithLength(indent + "/**\n" + joined + (joined.isEmpty() ? indent + " */" : "\n" + indent + " */"), lines.size() + 2);
    }

    private static void appendJust(List<String> lines, Map<String, List<String>> tags, String ... toAdd) {
        HashMap<String, List<String>> newTags = new HashMap<String, List<String>>();
        for (String tag : toAdd) {
            List<String> n = tags.get(tag);
            if (n == null) continue;
            newTags.put(tag, n);
            tags.remove(tag);
        }
        newTags.entrySet().stream().sorted(Map.Entry.comparingByKey(TAGS_ORDER)).flatMap(e -> ((List)e.getValue()).stream().sorted(Comparator.naturalOrder()).flatMap(v -> DocFormatter.formatTag((String)e.getKey(), v).stream())).forEach(lines::add);
    }

    private static List<String> formatTag(String name, String value) {
        ArrayList<String> out = new ArrayList<String>();
        String start = "@" + name;
        StringBuilder builder = new StringBuilder().append(start).append(' ');
        String[] split = value.split("\n");
        for (int i = 0; i < split.length; ++i) {
            if (i == 0) {
                builder.append(split[i].trim());
                if (i >= split.length - 1) continue;
                out.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            builder.append(DocFormatter.repeat(" ", start.length() + 1)).append(split[i].trim());
            if (i >= split.length - 1) continue;
            out.add(builder.toString());
            builder = new StringBuilder();
        }
        out.add(builder.toString());
        return out;
    }

    private static void appendParameters(List<String> lines, String[] parameters, IntFunction<String> nameGetter) {
        int paramsIndentSize = 0;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] == null) continue;
            paramsIndentSize = Math.max(paramsIndentSize, ("@param " + nameGetter.apply(i)).length() + 1);
        }
        int finalParamsIndentSize = paramsIndentSize;
        String paramIndent = DocFormatter.repeat(" ", paramsIndentSize);
        for (int i = 0; i < parameters.length; ++i) {
            int finalI = i;
            DocFormatter.splitIntoMultipleLines(80 - paramsIndentSize, parameters[i], (line, index) -> {
                if (index == 0) {
                    String start = "@param " + (String)nameGetter.apply(finalI);
                    String startIndent = DocFormatter.repeat(" ", finalParamsIndentSize - start.length());
                    lines.add(start + startIndent + line);
                } else {
                    lines.add(paramIndent + line);
                }
            });
        }
    }

    public static void splitIntoMultipleLines(int maxLength, @Nullable String str, BiConsumer<String, Integer> consumer) {
        if (str == null) {
            return;
        }
        BreakIterator boundary = BreakIterator.getWordInstance(Locale.ENGLISH);
        StringBuilder currentLine = null;
        int amount = 0;
        boundary.setText(str);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String word = str.substring(start, end);
            if (currentLine == null) {
                currentLine = new StringBuilder().append(word);
            } else if (currentLine.length() + word.length() > maxLength) {
                consumer.accept(currentLine.toString().trim(), amount++);
                currentLine = new StringBuilder().append(word);
            } else {
                currentLine.append(word);
            }
            start = end;
            end = boundary.next();
        }
        if (currentLine != null) {
            consumer.accept(currentLine.toString(), amount);
        }
    }

    public static String repeat(String string, int amount) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static final class WithLength {
        public final String doc;
        public final int length;

        public WithLength(String doc, int length) {
            this.doc = doc;
            this.length = length;
        }
    }
}

