/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.neoforged.javadoctor.injector.ClassParserFactory;
import net.neoforged.javadoctor.injector.CombiningJavadocProvider;
import net.neoforged.javadoctor.injector.JavadocInjector;
import net.neoforged.javadoctor.injector.JavadocProvider;
import net.neoforged.javadoctor.injector.Result;
import net.neoforged.javadoctor.io.gson.GsonJDocIO;
import org.jetbrains.annotations.Nullable;

public class Main {
    public static void main(String[] args) throws Exception {
        Throwable throwable;
        Reader is;
        ArrayList<JavadocProvider> providers;
        OptionSet options;
        ArgumentAcceptingOptionSpec javaVersion;
        ArgumentAcceptingOptionSpec classpathO;
        ArgumentAcceptingOptionSpec jsonO;
        ArgumentAcceptingOptionSpec outputO;
        ArgumentAcceptingOptionSpec inputO;
        block69: {
            OptionParser parser = new OptionParser();
            inputO = parser.accepts("input", "Input jar file").withRequiredArg().ofType(File.class).required();
            outputO = parser.accepts("output", "Output jar file").withRequiredArg().ofType(File.class).required();
            jsonO = parser.accepts("doctor", "The Javadoctor json file(s)").withRequiredArg().ofType(File.class);
            classpathO = parser.accepts("classpath", "The classpath to use when resolving classes").withRequiredArg().ofType(File.class);
            javaVersion = parser.accepts("java-version", "The version of Java to use for parsing").withRequiredArg().ofType(Integer.class).required();
            try {
                options = parser.parse(args);
            }
            catch (OptionException ex) {
                System.err.println("Error: " + ex.getMessage());
                System.err.println();
                parser.printHelpOn((OutputStream)System.err);
                System.exit(1);
                return;
            }
            providers = new ArrayList<JavadocProvider>();
            FileSystem in = FileSystems.newFileSystem(((File)options.valueOf((OptionSpec)inputO)).toPath(), (ClassLoader)null);
            Object object = null;
            try {
                Path javadoctorJson = in.getPath("javadoctor.json", new String[0]);
                if (!Files.exists(javadoctorJson, new LinkOption[0])) break block69;
                is = Files.newBufferedReader(javadoctorJson);
                throwable = null;
                try {
                    providers.add(GsonJDocIO.read((Gson)GsonJDocIO.GSON, (JsonObject)((JsonObject)GsonJDocIO.GSON.fromJson(is, JsonObject.class))).getClassDocs()::get);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Throwable javadoctorJson) {
                object = javadoctorJson;
                throw javadoctorJson;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable javadoctorJson) {
                            ((Throwable)object).addSuppressed(javadoctorJson);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        List doctors = options.valuesOf((OptionSpec)jsonO);
        if (providers.isEmpty() && doctors.isEmpty()) {
            System.err.println("No doctor files have been specified and none could be found in the input jar!");
            System.exit(1);
        }
        for (File doctor : doctors) {
            is = new FileReader(doctor);
            throwable = null;
            try {
                providers.add(GsonJDocIO.read((Gson)GsonJDocIO.GSON, (JsonObject)((JsonObject)GsonJDocIO.GSON.fromJson(is, JsonObject.class))).getClassDocs()::get);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                is.close();
            }
        }
        ClassParserFactory factory = ServiceLoader.load(ClassParserFactory.class).iterator().next();
        JavadocInjector injector = new JavadocInjector(factory.createParser(options.valuesOf((OptionSpec)classpathO), (Integer)options.valueOf((OptionSpec)javaVersion)), new CombiningJavadocProvider(providers));
        Path out = ((File)options.valueOf((OptionSpec)outputO)).toPath();
        Files.createDirectories(out.getParent(), new FileAttribute[0]);
        try (ZipInputStream input = new ZipInputStream(new FileInputStream((File)options.valueOf((OptionSpec)inputO)));
             ZipOutputStream output = new ZipOutputStream(Files.newOutputStream(out, new OpenOption[0]));){
            ZipEntry next;
            while ((next = input.getNextEntry()) != null) {
                ZipEntry newEntry = new ZipEntry(next);
                if (next.getName().endsWith(".java")) {
                    byte[] bytes = Main.readAllBytes(input);
                    Result<JavadocInjector.InjectionResult> result = injector.injectDocs(next.getName().substring(0, next.getName().length() - 5).replace('/', '.'), new String(bytes, StandardCharsets.UTF_8), Main.getMappings(next));
                    if (result.getResult().isPresent()) {
                        JavadocInjector.InjectionResult res = result.getResult().get();
                        if (res.mapping != null) {
                            newEntry.setExtra(Main.getCodeLineData(res.mapping));
                        }
                        output.putNextEntry(newEntry);
                        output.write(res.newSource.getBytes(StandardCharsets.UTF_8));
                    } else {
                        System.err.println("Encountered problems parsing class " + next.getName() + ":");
                        result.getProblems().forEach(System.err::println);
                        output.putNextEntry(newEntry);
                        output.write(bytes);
                    }
                } else {
                    output.putNextEntry(newEntry);
                    if (!newEntry.isDirectory()) {
                        Main.copy(input, output);
                    }
                }
                output.closeEntry();
            }
        }
    }

    private static void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) != -1) {
            target.write(buf, 0, length);
        }
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    @Nullable
    private static int[] getMappings(ZipEntry entry) throws IOException {
        if (entry.getExtra() == null || entry.getExtra().length < 5) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(entry.getExtra());
        buf.order(ByteOrder.LITTLE_ENDIAN);
        if (buf.getShort() != 17990) {
            return null;
        }
        int length = (buf.getShort() - 1) / 2;
        byte version = buf.get();
        if (version != 1) {
            throw new IllegalArgumentException("Unknown mapping file version: " + version + ". entry: " + entry.getName());
        }
        int[] mapping = new int[length];
        for (int i = 0; i < length; ++i) {
            mapping[i] = buf.getShort();
        }
        return mapping;
    }

    private static byte[] getCodeLineData(int[] mappings) {
        if (mappings == null || mappings.length == 0) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(5 + mappings.length * 2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort((short)17990);
        buf.putShort((short)(mappings.length * 2 + 1));
        buf.put((byte)1);
        for (int line : mappings) {
            buf.putShort((short)line);
        }
        return buf.array();
    }
}

