/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.zipinject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class ConsoleTool {
    public static void main(String[] args) throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec baseO = parser.accepts("base", "The base zip to inject into").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output", "The location of the output zip").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec injectO = parser.accepts("inject", "A zip or directory to inject").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec sourcePrefixO = parser.accepts("path-prefix", "A prefix to strip from source file paths").withRequiredArg();
        ArgumentAcceptingOptionSpec packageInfoPackagesO = parser.accepts("inject-package-info", "A prefix that packages that should contain a package-info have").withRequiredArg().ofType(String.class);
        try {
            OptionSet options = parser.parse(args);
            List injects = options.valuesOf((OptionSpec)injectO);
            ArrayList<Path> injectRoots = new ArrayList<Path>();
            for (File inject : injects) {
                if (!inject.isDirectory()) {
                    if (!inject.exists()) {
                        throw new IllegalArgumentException("Injection path " + inject + " doesn't exist");
                    }
                    try {
                        FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + inject.toURI()), Collections.emptyMap());
                        injectRoots.add(fs.getRootDirectories().iterator().next());
                        continue;
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Injection path " + inject + " is not a zip", exception);
                    }
                }
                injectRoots.add(inject.toPath().toAbsolutePath());
            }
            String packageInfoTemplate = null;
            if (options.has((OptionSpec)packageInfoPackagesO)) {
                packageInfoTemplate = ConsoleTool.findPackageInfoTemplate(injectRoots);
            }
            String sourcePrefix = options.has((OptionSpec)sourcePrefixO) ? (String)options.valueOf((OptionSpec)sourcePrefixO) : null;
            try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(((File)options.valueOf((OptionSpec)outputO)).toPath(), new OpenOption[0]));){
                ConsoleTool.copyInputZipContent(((File)options.valueOf((OptionSpec)baseO)).toPath(), zos, packageInfoTemplate, options.valuesOf((OptionSpec)packageInfoPackagesO));
                for (Path folder : injectRoots) {
                    Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]).sorted();
                    Throwable throwable = null;
                    try {
                        stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                            String outputPath = folder.relativize((Path)path).toString().replace('\\', '/');
                            try {
                                if (sourcePrefix != null && outputPath.startsWith(sourcePrefix) ? (outputPath = outputPath.substring(sourcePrefix.length())).isEmpty() : outputPath.equals("package-info-template.java")) {
                                    return;
                                }
                                zos.putNextEntry(new ZipEntry(outputPath));
                                Files.copy(path, zos);
                                zos.closeEntry();
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            for (Path injectRoot : injectRoots) {
                if (!injectRoot.getFileSystem().provider().getScheme().equals("jar")) continue;
                injectRoot.getFileSystem().close();
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private static String findPackageInfoTemplate(List<Path> roots) throws IOException {
        for (Path injectedSource : roots) {
            Path subPath = injectedSource.resolve("package-info-template.java");
            if (!Files.isRegularFile(subPath, new LinkOption[0])) continue;
            return new String(Files.readAllBytes(subPath), StandardCharsets.UTF_8);
        }
        return null;
    }

    private static void copyInputZipContent(Path inputZipFile, ZipOutputStream zos, String packageInfoTemplateContent, List<String> packagePrefixes) throws IOException {
        HashSet<String> visited = new HashSet<String>();
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(inputZipFile, new OpenOption[0]));){
            ZipEntry entry;
            block9: while ((entry = zis.getNextEntry()) != null) {
                String pkg;
                zos.putNextEntry(entry);
                ConsoleTool.copy(zis, zos);
                zos.closeEntry();
                if (packageInfoTemplateContent == null || !visited.add(pkg = entry.isDirectory() && !entry.getName().endsWith("/") ? entry.getName() : (entry.getName().indexOf(47) == -1 ? "" : entry.getName().substring(0, entry.getName().lastIndexOf(47))))) continue;
                for (String prefix : packagePrefixes) {
                    if (!pkg.startsWith(prefix)) continue;
                    zos.putNextEntry(new ZipEntry(pkg + "/package-info.java"));
                    zos.write(packageInfoTemplateContent.replace("{PACKAGE}", pkg.replaceAll("/", ".")).getBytes(StandardCharsets.UTF_8));
                    zos.closeEntry();
                    continue block9;
                }
            }
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
    }
}

