/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import com.nothome.delta.Delta;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Patch {
    private static final byte[] EMPTY_DATA = new byte[0];
    private static final Delta DELTA = new Delta();
    public final String obf;
    public final String srg;
    public final boolean exists;
    public final int checksum;
    public final byte[] data;

    private Patch(String obf, String srg, boolean exists, int checksum, byte[] data) {
        this.obf = obf;
        this.srg = srg;
        this.exists = exists;
        this.checksum = checksum;
        this.data = data;
    }

    public static Patch from(String obf, String srg, byte[] clean, byte[] dirty, boolean minimizePatch) throws IOException {
        if (minimizePatch) {
            dirty = Patch.shrinkDirtyForPatch(clean, dirty);
        }
        byte[] diff = dirty.length == 0 ? EMPTY_DATA : DELTA.compute(clean, dirty);
        int checksum = clean.length == 0 ? 0 : Patch.adlerHash(clean);
        return new Patch(obf, srg, clean.length != 0, checksum, diff);
    }

    private static byte[] shrinkDirtyForPatch(byte[] clean, byte[] dirty) {
        if (clean.length == 0 || dirty.length == 0) {
            return dirty;
        }
        ClassReader cleanReader = new ClassReader(clean);
        ClassReader dirtyReader = new ClassReader(dirty);
        ClassWriter writer = new ClassWriter(cleanReader, 0);
        dirtyReader.accept((ClassVisitor)writer, 0);
        return writer.toByteArray();
    }

    public byte[] toBytes() {
        return this.toBytes(false);
    }

    public byte[] toBytes(boolean legacy) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.data.length + this.obf.length() + this.srg.length() + 1);
        DataOutputStream out = new DataOutputStream(bos);
        try {
            if (legacy) {
                if (this.data.length == 0) {
                    return null;
                }
                out.writeUTF(this.obf);
                out.writeUTF(this.obf.replace('/', '.'));
                out.writeUTF(this.srg.replace('/', '.'));
            } else {
                out.writeByte(1);
                out.writeUTF(this.obf);
                out.writeUTF(this.srg);
            }
            out.writeBoolean(this.exists);
            if (this.exists) {
                out.writeInt(this.checksum);
            }
            out.writeInt(this.data.length);
            out.write(this.data);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static Patch from(InputStream stream) throws IOException {
        return Patch.from(stream, false);
    }

    public static Patch from(InputStream stream, boolean legacy) throws IOException {
        String srg;
        String obf;
        DataInputStream input = new DataInputStream(stream);
        int version = -1;
        if (legacy) {
            obf = input.readUTF();
            input.readUTF();
            srg = input.readUTF().replace('.', '/');
        } else {
            version = input.readByte() & 0xFF;
            if (version != 1) {
                throw new IOException("Unsupported patch format: " + version);
            }
            obf = input.readUTF();
            srg = input.readUTF();
        }
        boolean exists = input.readBoolean();
        int checksum = exists ? input.readInt() : 0;
        int length = input.readInt();
        byte[] data = new byte[length];
        input.readFully(data);
        return new Patch(obf, srg, exists, checksum, data);
    }

    public String getName() {
        if (this.srg.equals(this.obf)) {
            return this.srg;
        }
        return this.srg + "(" + this.obf + ")";
    }

    public int checksum(byte[] data) {
        return data.length == 0 ? 0 : Patch.adlerHash(data);
    }

    private static int adlerHash(byte[] input) {
        Adler32 hasher = new Adler32();
        hasher.update(input);
        return (int)hasher.getValue();
    }
}

