/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.support.JsonViewClass;
import net.nemerosa.ontrack.ui.resource.DefaultResourceModule;
import net.nemerosa.ontrack.ui.resource.JSONResourceModule;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import net.nemerosa.ontrack.ui.resource.ResourceDecorator;
import net.nemerosa.ontrack.ui.resource.ResourceModule;
import net.nemerosa.ontrack.ui.resource.ResourceObjectMapper;

public class ResourceObjectMapperFactory {
    private final ObjectMapper objectMapper;

    public ResourceObjectMapperFactory() {
        this(ObjectMapperFactory.create());
    }

    public ResourceObjectMapperFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ResourceObjectMapper resourceObjectMapper(ResourceContext resourceContext, ResourceDecorator<?> ... decorators) {
        return this.resourceObjectMapper(Collections.singletonList(new DefaultResourceModule(Arrays.asList(decorators))), resourceContext);
    }

    public ResourceObjectMapper resourceObjectMapper(List<ResourceModule> resourceModules, ResourceContext resourceContext) {
        ObjectMapper mapper = this.objectMapper.copy();
        for (ResourceModule resourceModule : resourceModules) {
            mapper = mapper.registerModule((Module)new JSONResourceModule(resourceModule, resourceContext));
        }
        return new DefaultResourceObjectMapper(mapper, resourceContext);
    }

    protected class DefaultResourceObjectMapper
    implements ResourceObjectMapper {
        private final ObjectMapper mapper;
        private final ResourceContext resourceContext;

        public DefaultResourceObjectMapper(ObjectMapper mapper, ResourceContext resourceContext) {
            this.mapper = mapper;
            this.resourceContext = resourceContext;
        }

        @Override
        public ObjectMapper getObjectMapper() {
            return this.mapper;
        }

        @Override
        public ResourceContext getResourceContext() {
            return this.resourceContext;
        }

        @Override
        public String write(Object o) throws JsonProcessingException {
            return this.write(o, JsonViewClass.getViewClass((Object)o));
        }

        @Override
        public void write(JsonGenerator jgen, Object o) throws IOException {
            this.write(jgen, o, JsonViewClass.getViewClass((Object)o));
        }

        @Override
        public void write(OutputStream out, Object o) throws IOException {
            this.write(out, o, JsonViewClass.getViewClass((Object)o));
        }

        @Override
        public void write(OutputStream out, Object o, Class<?> view) throws IOException {
            this.getObjectWriter(view).writeValue(out, o);
        }

        protected ObjectWriter getObjectWriter(Class<?> view) {
            return this.mapper.writerWithView(view);
        }

        @Override
        public String write(Object o, Class<?> view) throws JsonProcessingException {
            return this.getObjectWriter(view).writeValueAsString(o);
        }

        @Override
        public void write(JsonGenerator jgen, Object o, Class<?> view) throws IOException {
            this.getObjectWriter(view).writeValue(jgen, o);
        }
    }
}

