/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogService;
import net.nemerosa.ontrack.ui.resource.LinkDefinition;
import net.nemerosa.ontrack.ui.resource.ResourceDecorationContributor;
import net.nemerosa.ontrack.ui.resource.ResourceDecorationContributorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceDecorationContributorServiceImpl
implements ResourceDecorationContributorService {
    private final ApplicationLogService logService;
    private final Collection<ResourceDecorationContributor> contributors;

    @Autowired
    public ResourceDecorationContributorServiceImpl(ApplicationLogService logService, Collection<ResourceDecorationContributor> contributors) {
        this.logService = logService;
        this.contributors = contributors;
    }

    @Override
    public <T extends ProjectEntity> List<LinkDefinition<T>> getLinkDefinitions(ProjectEntityType projectEntityType) {
        ArrayList definitions = new ArrayList();
        this.contributors.forEach(contributor -> {
            if (contributor.applyTo(projectEntityType)) {
                try {
                    ResourceDecorationContributor tResourceDecorationContributor = contributor;
                    definitions.addAll(tResourceDecorationContributor.getLinkDefinitions());
                }
                catch (Exception ex) {
                    this.logService.log(ApplicationLogEntry.fatal((Throwable)ex, (NameDescription)NameDescription.nd((String)"ui-resource-decoration", (String)"Issue when collecting UI resource decoration"), (String)contributor.getClass().getName()).withDetail("ui-resource-type", projectEntityType.name()).withDetail("ui-resource-decorator", contributor.getClass().getName()));
                }
            }
        });
        return definitions;
    }
}

