/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.ProjectFunction;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.ui.resource.EntityPageLinkDefinition;
import net.nemerosa.ontrack.ui.resource.LinkDefinition;
import net.nemerosa.ontrack.ui.resource.PagePathLinkDefinition;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import net.nemerosa.ontrack.ui.resource.SimpleLinkDefinition;

public class LinkDefinitions {
    public static <T extends ProjectEntity, P extends ProjectFunction> BiPredicate<T, ResourceContext> withProjectFn(Class<P> projectFn) {
        return (e, resourceContext) -> resourceContext.isProjectFunctionGranted((ProjectEntity)e, (Class<? extends ProjectFunction>)projectFn);
    }

    public static <T extends ProjectEntity, G extends GlobalFunction> BiPredicate<T, ResourceContext> withGlobalFn(Class<G> globalFn) {
        return (e, resourceContext) -> resourceContext.isGlobalFunctionGranted(globalFn);
    }

    public static <T> LinkDefinition<T> link(String name, BiFunction<T, ResourceContext, Object> linkFn, BiPredicate<T, ResourceContext> checkFn) {
        return new SimpleLinkDefinition<T>(name, linkFn, checkFn);
    }

    public static <T extends ProjectEntity> LinkDefinition<T> link(String name, BiFunction<T, ResourceContext, Object> linkFn) {
        return LinkDefinitions.link(name, linkFn, (T t, ResourceContext rc) -> true);
    }

    public static <T extends ProjectEntity> LinkDefinition<T> link(String name, Function<T, Object> linkFn) {
        return LinkDefinitions.link(name, (T t, ResourceContext resourceContext) -> linkFn.apply(t));
    }

    public static <T extends ProjectEntity> LinkDefinition<T> self(Function<T, Object> linkFn) {
        return LinkDefinitions.link("_self", linkFn);
    }

    public static <T extends ProjectEntity> LinkDefinition<T> link(String name, Function<T, Object> linkFn, BiPredicate<T, ResourceContext> checkFn) {
        return LinkDefinitions.link(name, (T t, ResourceContext resourceContext) -> linkFn.apply(t), checkFn);
    }

    public static <T extends ProjectEntity, P extends ProjectFunction> LinkDefinition<T> delete(Function<T, Object> linkFn, Class<P> fn) {
        return LinkDefinitions.link("_delete", linkFn, LinkDefinitions.withProjectFn(fn));
    }

    public static <T extends ProjectEntity> LinkDefinition<T> page() {
        return new EntityPageLinkDefinition((e, rc) -> true);
    }

    public static <T extends ProjectEntity, P extends ProjectFunction> LinkDefinition<T> page(String name, Class<P> projectFn, String path, Object ... arguments) {
        return LinkDefinitions.page(name, LinkDefinitions.withProjectFn(projectFn), path, arguments);
    }

    public static <T extends ProjectEntity> LinkDefinition<T> page(String name, BiPredicate<T, ResourceContext> checkFn, String path, Object ... arguments) {
        return LinkDefinitions.page(name, checkFn, (r, rc) -> String.format(path, arguments));
    }

    public static <T extends ProjectEntity> LinkDefinition<T> page(String name, BiPredicate<T, ResourceContext> checkFn, BiFunction<T, ResourceContext, String> pathFn) {
        return new PagePathLinkDefinition<T>(name, pathFn, checkFn);
    }
}

