/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.nemerosa.ontrack.common.CachedSupplier;
import net.nemerosa.ontrack.ui.resource.AbstractResourceDecorator;
import net.nemerosa.ontrack.ui.resource.Link;
import net.nemerosa.ontrack.ui.resource.LinkDefinition;
import net.nemerosa.ontrack.ui.resource.LinksBuilder;
import net.nemerosa.ontrack.ui.resource.ResourceContext;

public abstract class AbstractLinkResourceDecorator<T>
extends AbstractResourceDecorator<T> {
    private final Supplier<Iterable<LinkDefinition<T>>> linkDefinitions = CachedSupplier.of(this::getLinkDefinitions);

    protected AbstractLinkResourceDecorator(Class<T> resourceClass) {
        super(resourceClass);
    }

    @Override
    public List<Link> links(T resource, ResourceContext resourceContext) {
        LinksBuilder linksBuilder = resourceContext.links();
        for (LinkDefinition<T> linkDefinition : this.linkDefinitions.get()) {
            if (!((Boolean)linkDefinition.getCheckFn().invoke(resource, (Object)resourceContext)).booleanValue()) continue;
            linksBuilder = linkDefinition.addLink(linksBuilder, resource, resourceContext);
        }
        return linksBuilder.build();
    }

    protected abstract Iterable<LinkDefinition<T>> getLinkDefinitions();

    @Override
    public List<String> getLinkNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (LinkDefinition<T> ld : this.linkDefinitions.get()) {
            names.add(ld.getName());
        }
        return names;
    }
}

