/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.beans.ConstructorProperties;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.ui.resource.LinkDefinition;
import net.nemerosa.ontrack.ui.resource.LinksBuilder;
import net.nemerosa.ontrack.ui.resource.ResourceContext;

public class SimpleLinkDefinition<T extends ProjectEntity>
implements LinkDefinition<T> {
    private final String name;
    private final BiFunction<T, ResourceContext, Object> linkFn;
    private final BiPredicate<T, ResourceContext> checkFn;

    @Override
    public LinksBuilder addLink(LinksBuilder linksBuilder, T resource, ResourceContext resourceContext) {
        return linksBuilder.link(this.name, this.linkFn.apply(resource, resourceContext));
    }

    @ConstructorProperties(value={"name", "linkFn", "checkFn"})
    public SimpleLinkDefinition(String name, BiFunction<T, ResourceContext, Object> linkFn, BiPredicate<T, ResourceContext> checkFn) {
        this.name = name;
        this.linkFn = linkFn;
        this.checkFn = checkFn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BiFunction<T, ResourceContext, Object> getLinkFn() {
        return this.linkFn;
    }

    @Override
    public BiPredicate<T, ResourceContext> getCheckFn() {
        return this.checkFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleLinkDefinition)) {
            return false;
        }
        SimpleLinkDefinition other = (SimpleLinkDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BiFunction<T, ResourceContext, Object> this$linkFn = this.getLinkFn();
        BiFunction<T, ResourceContext, Object> other$linkFn = other.getLinkFn();
        if (this$linkFn == null ? other$linkFn != null : !this$linkFn.equals(other$linkFn)) {
            return false;
        }
        BiPredicate<T, ResourceContext> this$checkFn = this.getCheckFn();
        BiPredicate<T, ResourceContext> other$checkFn = other.getCheckFn();
        return !(this$checkFn == null ? other$checkFn != null : !this$checkFn.equals(other$checkFn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleLinkDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BiFunction<T, ResourceContext, Object> $linkFn = this.getLinkFn();
        result = result * 59 + ($linkFn == null ? 43 : $linkFn.hashCode());
        BiPredicate<T, ResourceContext> $checkFn = this.getCheckFn();
        result = result * 59 + ($checkFn == null ? 43 : $checkFn.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleLinkDefinition(name=" + this.getName() + ", linkFn=" + this.getLinkFn() + ", checkFn=" + this.getCheckFn() + ")";
    }
}

