/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.nemerosa.ontrack.model.structure.ViewSupplier;
import net.nemerosa.ontrack.ui.resource.LinkContainer;
import net.nemerosa.ontrack.ui.resource.Pagination;

public class Resources<T>
extends LinkContainer<Resources<T>>
implements ViewSupplier {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Pagination pagination;
    private final Collection<T> resources;
    @JsonIgnore
    private final Class<?> viewType;

    protected Resources(Collection<T> resources, URI self, Pagination pagination, Class<?> viewType) {
        super(self);
        this.pagination = pagination;
        this.resources = resources;
        this.viewType = viewType;
    }

    public Resources<T> forView(Class<?> viewType) {
        return new Resources<T>(this.resources, this.get_self(), this.pagination, viewType);
    }

    public static <R> Resources<R> of(Stream<R> resources, URI href) {
        return Resources.of(resources.collect(Collectors.toList()), href);
    }

    public static <R> Resources<R> of(Collection<R> resources, URI href) {
        return new Resources<R>(resources, href, Pagination.NONE, Object.class);
    }

    public Resources<T> withPagination(Pagination pagination) {
        return this.pagination == pagination ? this : new Resources<T>(this.resources, this.get_self(), pagination, this.viewType);
    }

    public <V> Resources<V> transform(Function<T, V> fn) {
        return (Resources)new Resources<T>(this.resources.stream().map(fn).collect(Collectors.toList()), this.get_self(), this.pagination, Object.class).withLinks(this.getLinks());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resources)) {
            return false;
        }
        Resources other = (Resources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination)) {
            return false;
        }
        Collection<T> this$resources = this.getResources();
        Collection<T> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Class<?> this$viewType = this.getViewType();
        Class<?> other$viewType = other.getViewType();
        return !(this$viewType == null ? other$viewType != null : !this$viewType.equals(other$viewType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Resources;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        Collection<T> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Class<?> $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 43 : $viewType.hashCode());
        return result;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public Collection<T> getResources() {
        return this.resources;
    }

    public Class<?> getViewType() {
        return this.viewType;
    }

    @Override
    public String toString() {
        return "Resources(pagination=" + this.getPagination() + ", resources=" + this.getResources() + ", viewType=" + this.getViewType() + ")";
    }
}

