/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.beans.ConstructorProperties;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.ui.resource.LinkDefinition;
import net.nemerosa.ontrack.ui.resource.LinksBuilder;
import net.nemerosa.ontrack.ui.resource.ResourceContext;

public class PagePathLinkDefinition<T extends ProjectEntity>
implements LinkDefinition<T> {
    private final String name;
    private final BiFunction<T, ResourceContext, String> pathFn;
    private final BiPredicate<T, ResourceContext> checkFn;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LinksBuilder addLink(LinksBuilder linksBuilder, T resource, ResourceContext resourceContext) {
        return linksBuilder.page(this.name, this.checkFn.test(resource, resourceContext), this.pathFn.apply(resource, resourceContext), new Object[0]);
    }

    @ConstructorProperties(value={"name", "pathFn", "checkFn"})
    public PagePathLinkDefinition(String name, BiFunction<T, ResourceContext, String> pathFn, BiPredicate<T, ResourceContext> checkFn) {
        this.name = name;
        this.pathFn = pathFn;
        this.checkFn = checkFn;
    }

    public BiFunction<T, ResourceContext, String> getPathFn() {
        return this.pathFn;
    }

    @Override
    public BiPredicate<T, ResourceContext> getCheckFn() {
        return this.checkFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagePathLinkDefinition)) {
            return false;
        }
        PagePathLinkDefinition other = (PagePathLinkDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BiFunction<T, ResourceContext, String> this$pathFn = this.getPathFn();
        BiFunction<T, ResourceContext, String> other$pathFn = other.getPathFn();
        if (this$pathFn == null ? other$pathFn != null : !this$pathFn.equals(other$pathFn)) {
            return false;
        }
        BiPredicate<T, ResourceContext> this$checkFn = this.getCheckFn();
        BiPredicate<T, ResourceContext> other$checkFn = other.getCheckFn();
        return !(this$checkFn == null ? other$checkFn != null : !this$checkFn.equals(other$checkFn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PagePathLinkDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BiFunction<T, ResourceContext, String> $pathFn = this.getPathFn();
        result = result * 59 + ($pathFn == null ? 43 : $pathFn.hashCode());
        BiPredicate<T, ResourceContext> $checkFn = this.getCheckFn();
        result = result * 59 + ($checkFn == null ? 43 : $checkFn.hashCode());
        return result;
    }

    public String toString() {
        return "PagePathLinkDefinition(name=" + this.getName() + ", pathFn=" + this.getPathFn() + ", checkFn=" + this.getCheckFn() + ")";
    }
}

