/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import java.io.IOException;
import net.nemerosa.ontrack.ui.resource.Link;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import net.nemerosa.ontrack.ui.resource.ResourceDecorator;
import org.apache.commons.lang3.Validate;

public class ResourceDecoratorSerializer<T>
extends BeanSerializerBase {
    private final ResourceContext resourceContext;
    private final ResourceDecorator<T> resourceDecorator;

    public ResourceDecoratorSerializer(BeanSerializerBase serializer, ResourceDecorator<T> resourceDecorator, ResourceContext resourceContext) {
        super(serializer);
        this.resourceDecorator = resourceDecorator;
        this.resourceContext = resourceContext;
    }

    protected ResourceDecoratorSerializer(BeanSerializerBase src, ObjectIdWriter objectIdWriter, ResourceContext resourceContext, ResourceDecorator<T> resourceDecorator) {
        super(src, objectIdWriter);
        this.resourceContext = resourceContext;
        this.resourceDecorator = resourceDecorator;
    }

    protected ResourceDecoratorSerializer(BeanSerializerBase src, String[] toIgnore, ResourceContext resourceContext, ResourceDecorator<T> resourceDecorator) {
        super(src, toIgnore);
        this.resourceContext = resourceContext;
        this.resourceDecorator = resourceDecorator;
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new ResourceDecoratorSerializer<T>((BeanSerializerBase)this, objectIdWriter, this.resourceContext, this.resourceDecorator);
    }

    protected BeanSerializerBase withIgnorals(String[] toIgnore) {
        return new ResourceDecoratorSerializer<T>((BeanSerializerBase)this, toIgnore, this.resourceContext, this.resourceDecorator);
    }

    protected BeanSerializerBase asArraySerializer() {
        throw new UnsupportedOperationException("asArraySerializer");
    }

    public BeanSerializerBase withFilterId(Object filterId) {
        throw new UnsupportedOperationException("withFilterId");
    }

    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Validate.isTrue((boolean)this.resourceDecorator.appliesFor(bean.getClass()), (String)String.format("The bean class <%s> cannot be processed by the <%s> decorator.", bean.getClass().getName(), this.resourceDecorator.getClass().getName()), (Object[])new Object[0]);
        Object t = bean;
        jgen.writeStartObject();
        Object decoratedBean = this.resourceDecorator.decorateBeforeSerialization(t);
        this.serializeFields(decoratedBean, jgen, provider);
        for (Link link : this.resourceDecorator.links(decoratedBean, this.resourceContext)) {
            jgen.writeObjectField(link.getName(), (Object)link.getHref());
        }
        jgen.writeEndObject();
    }
}

