/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.beans.ConstructorProperties;
import java.net.URI;
import net.nemerosa.ontrack.model.structure.ViewSupplier;
import net.nemerosa.ontrack.ui.resource.LinkContainer;
import org.apache.commons.lang3.Validate;

@JsonPropertyOrder(alphabetic=true)
public class Resource<T>
extends LinkContainer<Resource<T>>
implements ViewSupplier {
    @JsonUnwrapped
    private final T data;
    @JsonIgnore
    private final Class<?> viewType;

    @ConstructorProperties(value={"data", "_self"})
    protected Resource(T data, URI self) {
        this(data, self, data.getClass());
    }

    private Resource(T data, URI self, Class<?> view) {
        super(self);
        Validate.notNull(data, (String)"Null data is not acceptable for a resource", (Object[])new Object[0]);
        this.data = data;
        this.viewType = view;
    }

    public static <R> Resource<R> of(R data, URI self) {
        return new Resource<R>(data, self);
    }

    public Resource<T> withView(Class<?> view) {
        return new Resource<T>(this.data, this.get_self(), view);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Class<?> this$viewType = this.getViewType();
        Class<?> other$viewType = other.getViewType();
        return !(this$viewType == null ? other$viewType != null : !this$viewType.equals(other$viewType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Resource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $data = this.getData();
        result = result * 59 + ($data == null ? 0 : $data.hashCode());
        Class<?> $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 0 : $viewType.hashCode());
        return result;
    }

    public T getData() {
        return this.data;
    }

    public Class<?> getViewType() {
        return this.viewType;
    }

    @Override
    public String toString() {
        return "Resource(data=" + this.getData() + ", viewType=" + this.getViewType() + ")";
    }
}

