/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.ProjectFunction;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.resource.Link;
import net.nemerosa.ontrack.ui.resource.LinksBuilder;
import net.nemerosa.ontrack.ui.resource.ResourceContext;

public class DefaultResourceContext
implements ResourceContext {
    private final URIBuilder uriBuilder;
    private final SecurityService securityService;

    public DefaultResourceContext(URIBuilder uriBuilder, SecurityService securityService) {
        this.uriBuilder = uriBuilder;
        this.securityService = securityService;
    }

    @Override
    public URI uri(Object methodInvocation) {
        return this.uriBuilder.build(methodInvocation);
    }

    @Override
    public LinksBuilder links() {
        return new DefaultLinksBuilder();
    }

    @Override
    public boolean isProjectFunctionGranted(int projectId, Class<? extends ProjectFunction> fn) {
        return this.securityService.isProjectFunctionGranted(projectId, fn);
    }

    @Override
    public boolean isGlobalFunctionGranted(Class<? extends GlobalFunction> fn) {
        return this.securityService.isGlobalFunctionGranted(fn);
    }

    protected class DefaultLinksBuilder
    implements LinksBuilder {
        private final Map<String, Link> links = new LinkedHashMap<String, Link>();

        protected DefaultLinksBuilder() {
        }

        @Override
        public LinksBuilder link(Link link) {
            this.links.put(link.getName(), link);
            return this;
        }

        @Override
        public LinksBuilder link(String name, URI uri) {
            return this.link(Link.of(name, uri));
        }

        @Override
        public LinksBuilder self(Object methodInvocation) {
            return this.link("_self", methodInvocation);
        }

        @Override
        public LinksBuilder link(String name, Object methodInvocation) {
            return this.link(name, DefaultResourceContext.this.uri(methodInvocation));
        }

        @Override
        public LinksBuilder link(String name, Object methodInvocation, boolean test) {
            if (test) {
                return this.link(name, methodInvocation);
            }
            return this;
        }

        @Override
        public LinksBuilder link(String name, Object methodInvocation, Class<? extends GlobalFunction> fn) {
            return this.link(name, methodInvocation, DefaultResourceContext.this.securityService.isGlobalFunctionGranted(fn));
        }

        @Override
        public LinksBuilder link(String name, Object methodInvocation, Class<? extends ProjectFunction> fn, int projectId) {
            return this.link(name, methodInvocation, DefaultResourceContext.this.securityService.isProjectFunctionGranted(projectId, fn));
        }

        @Override
        public LinksBuilder update(Object methodInvocation, Class<? extends ProjectFunction> fn, int projectId) {
            return this.link("_update", methodInvocation, fn, projectId);
        }

        @Override
        public LinksBuilder delete(Object methodInvocation, Class<? extends ProjectFunction> fn, int projectId) {
            return this.link("_delete", methodInvocation, fn, projectId);
        }

        @Override
        public LinksBuilder page(String name, String path, Object ... arguments) {
            return this.link(name, DefaultResourceContext.this.uriBuilder.page(path, arguments));
        }

        @Override
        public LinksBuilder page(String name, boolean allowed, String path, Object ... arguments) {
            if (allowed) {
                return this.page(name, path, arguments);
            }
            return this;
        }

        @Override
        public LinksBuilder page(String name, Class<? extends GlobalFunction> fn, String path, Object ... arguments) {
            return this.page(name, DefaultResourceContext.this.securityService.isGlobalFunctionGranted(fn), path, arguments);
        }

        @Override
        public LinksBuilder page(String name, Class<? extends ProjectFunction> fn, ProjectEntity projectEntity, String path, Object ... arguments) {
            return this.page(name, DefaultResourceContext.this.securityService.isProjectFunctionGranted(projectEntity, fn), path, arguments);
        }

        @Override
        public LinksBuilder entityURI(String name, ProjectEntity projectEntity, boolean allowed) {
            if (allowed) {
                return this.link(name, DefaultResourceContext.this.uriBuilder.getEntityURI(projectEntity));
            }
            return this;
        }

        @Override
        public LinksBuilder entityPage(String name, boolean allowed, ProjectEntity projectEntity) {
            if (allowed) {
                return this.link(name, DefaultResourceContext.this.uriBuilder.getEntityPage(projectEntity));
            }
            return this;
        }

        @Override
        public List<Link> build() {
            return new ArrayList<Link>(this.links.values());
        }
    }
}

